% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_test_data.R
\name{get_config}
\alias{get_config}
\title{Get Portfolio Configuration}
\usage{
get_config(
  df_site,
  min_pat_per_study = 100,
  min_sites_per_study = 10,
  anonymize = TRUE,
  pad_width = 4
)
}
\arguments{
\item{df_site}{dataframe aggregated on patient level with max_ae and max_visit}

\item{min_pat_per_study}{minimum number of patients per study, Default: 100}

\item{min_sites_per_study}{minimum number of sites per study, Default: 10}

\item{anonymize}{logical, Default: TRUE}

\item{pad_width}{padding width for newly created IDs, Default: 4}
}
\value{
dataframe with the following columns: \describe{
\item{\strong{study_id}}{study identification} \item{\strong{ae_per_visit_mean}}{mean
AE per visit per study} \item{\strong{site_number}}{site}
\item{\strong{max_visit_sd}}{standard deviation of maximum patient visits per
site} \item{\strong{max_visit_mean}}{mean of maximum patient visits per site}
\item{\strong{n_pat}}{number of patients} }
}
\description{
Get Portfolio configuration from a dataframe aggregated on
patient level with max_ae and max_visit. Will filter studies with only a few
sites and patients and will anonymize IDs. Portfolio configuration can be
used by \code{\link{sim_test_data_portfolio}} to generate data for an
artificial portfolio.
}
\examples{
\donttest{
df_visit1 <- sim_test_data_study(n_pat = 100, n_sites = 10,
                                 frac_site_with_ur = 0.4, ur_rate = 0.6)

df_visit1$study_id <- "A"

df_visit2 <- sim_test_data_study(n_pat = 100, n_sites = 10,
                                 frac_site_with_ur = 0.2, ur_rate = 0.1)

df_visit2$study_id <- "B"

df_visit <- dplyr::bind_rows(df_visit1, df_visit2)

df_site_max <- df_visit \%>\%
  dplyr::group_by(study_id, site_number, patnum) \%>\%
  dplyr::summarise(max_visit = max(visit),
            max_ae = max(n_ae),
            .groups = "drop")

df_config <- get_config(df_site_max)

df_config

df_portf <- sim_test_data_portfolio(df_config)

df_portf

df_scen <- sim_ur_scenarios(df_portf,
                            extra_ur_sites = 2,
                            ur_rate = c(0.5, 1))


df_scen

df_perf <- get_portf_perf(df_scen)

df_perf
}
}
\seealso{
\code{\link{sim_test_data_study}}
\code{\link{get_config}}
\code{\link{sim_test_data_portfolio}}
\code{\link{sim_ur_scenarios}}
\code{\link{get_portf_perf}}
}
