\name{vunif}
\alias{vunif}
\alias{Uniform}

\title{Variate Generator for the Uniform Distribution}
\description{
  Generates random variates from the uniform distribution, with options for
  independent streams and antithetic variates.
}
\usage{
  vunif(n, min = 0, max = 1, stream = NULL, antithetic = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{n}{number of observations}
  \item{min, max}{lower and upper limits of the distribution (must be finite)}
  \item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
    to generate uniform variates to invert via \code{\link[=qunif]{stats::qunif}}; 
    otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
    from which to generate uniform variates to invert via
    \code{\link[=qunif]{stats::qunif}}}
  \item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
    variate(s) generated via either \code{\link[=runif]{stats::runif}} or
    \code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
    \eqn{1 - u}}
}
\details{
  Generates random variates from the uniform distribution.

  Uniform variates are generated by inverting uniform(0,1) variates
  produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
  \code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}} (if
  \code{stream} is not \code{NULL}).
  In either case, \code{\link[=qunif]{stats::qunif}} is used to invert the
  uniform(0,1) variate(s).
  In this way, using \code{vunif} provides a monotone and synchronized
  uniform variate generator, although not particularly fast.

  The stream indicated must be an integer between 1 and 25 inclusive.

  The uniform distribution has density

           \deqn{f(x) = 1/(max-min)}
           
  for \eqn{min \le x \le max}.
}
\value{
  A vector of uniform random variates.
}
\seealso{
    \code{\link[=runif]{stats::runif}},
    \code{\link{rstream}}, \code{\link{set.seed}}
}
\author{Barry Lawson (\email{blawson@richmond.edu}), 
        Larry Leemis (\email{leemis@math.wm.edu})}
\examples{
set.seed(8675309)
vunif(3)  # inverts stats::runif using stats::qunif

set.seed(8675309)
vunif(3, min = -2, max = 2)  # inverts stats::runif using stats::qunif

set.seed(8675309)
vunif(3, -2, 2, stream = 1) # inverts rstream::rstream.sample using stats::qunif
vunif(3, -2, 2, stream = 2)

set.seed(8675309)
vunif(1, -2, 2, stream = 1) # inverts rstream::rstream.sample using stats::qunif
vunif(1, -2, 2, stream = 2)
vunif(1, -2, 2, stream = 1)
vunif(1, -2, 2, stream = 2)
vunif(1, -2, 2, stream = 1)
vunif(1, -2, 2, stream = 2)

set.seed(8675309)
variates <- vunif(1000, min = 0, max = 10, stream = 1)
set.seed(8675309)
variates <- vunif(1000, min = 0, max = 10, stream = 1, antithetic = TRUE)
}
\keyword{distribution}  % RShowDoc("KEYWORDS") for suggested list
\concept{random variate generation}
