% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_ReferenceEvapotranspiration.R
\name{cal_ET0_from_PM_for_daily}
\alias{cal_ET0_from_PM_for_daily}
\title{Calculating reference evapotranspiration from Penman-Monteith for
   daily}
\usage{
cal_ET0_from_PM_for_daily(Latitude, Altitude, J, Tmax, Tmin, Rs, RHmean, Wind)
}
\arguments{
\item{Latitude}{latitude (radian), positive for the northern hemisphere and
negative for the southern hemisphere.}

\item{Altitude}{station elevation above sea level [m].}

\item{J}{is the number of the day in the year between 1 (1 January) and 365 or
366 (31 December).}

\item{Tmax}{daily maximum air temperature (degrees Celsius).}

\item{Tmin}{daily minimum air temperature (degrees Celsius).}

\item{Rs}{Solar radiation [MJ m-2 d-1].}

\item{RHmean}{daily mean relative humidity \%.}

\item{Wind}{wind speed at 2 m height [m s-1].}
}
\value{
A vector for reference evapotranspiration (mm/day)
}
\description{
Based on lat, z, J, Tmax, Tmin, n, RHmax, RHmin, windSpeed parameters,
   reference evapotranspiration was calculated by Penman-Monteith.
}
\examples{
 library(simET)
 data("FIalfalfa")
 names(FIalfalfa)
 Result_data<- dplyr::mutate(FIalfalfa,
                      ET0=cal_ET0_from_PM_for_daily(Latitude=Latitude,
                                                   Altitude=Altitude,
                                                   J=Julian,
                                                   Tmax=Tmax,
                                                   Tmin=Tmin,
                                                   Rs=Rs,
                                                   RHmean=RHmean,
                                                   Wind=Wind))
 names(Result_data)
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M.
   FAO Irrigation and drainage paper No. 56. Rome: Food and Agriculture
   Organization of the United Nations, 1998.
}
