% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_meteorlogy.R
\name{cal_angerFromSouth}
\alias{cal_angerFromSouth}
\title{Calculating anger from south}
\usage{
cal_angerFromSouth(latitude, solar_altitude, solar_declination)
}
\arguments{
\item{latitude}{is the latitude data (Radian).}

\item{solar_altitude}{It can be calculated from pi/2-cal_solarinclination.}

\item{solar_declination}{is solar declination anger. It can be calculated from cal_solardeclination()}
}
\value{
A vector for anger from south (Radian)
}
\description{
A parameter used to determine the position of the sun relative
   to the observer (the other one is solar inclination).
}
\details{
The minus and positive signs are taken before and after solar noon,
   receptively. The reason for having the positive-and-negative signs is
   merely an artificial convention so that we are able to distinguish between
   the sun lying westwards (posite angles and after solar noon) and eastwards
   (negative angles and before solar noon).
}
\examples{
cal_angerFromSouth(latitude=0.52,solar_altitude=-0.715,solar_declination=-0.2974005)
}
\references{
Teh CBS.Introduction to mathematical modeling of crop growth:
           How the equations are derived and assembled into a computer model.
           Brown Walker Press, 2006.
}
