% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stutter_type.R
\name{stutter_type}
\alias{stutter_type}
\title{Defines a stutter type to be used in the allele specific stutter model.}
\usage{
stutter_type(
  name,
  delta,
  applies_to_all_loci = TRUE,
  stutter_regression,
  stutter_exceptions,
  applies_to_loci,
  repeat_length_by_marker
)
}
\arguments{
\item{name}{Character. Name of the stutter, e.g. "BackStutter"}

\item{delta}{Numeric. When length one, repeat units gained (lost when negative). When length two, the second element is the number of base pairs gained (lost).}

\item{applies_to_all_loci}{Logical. Defaults to TRUE.}

\item{stutter_regression}{Function. See \link{read_stutter_regression}.}

\item{stutter_exceptions}{Optionally a list. See \link{read_stutter_exceptions}.}

\item{applies_to_loci}{Optionally a character vector of locus names to which this stutter type applies.}

\item{repeat_length_by_marker}{Optionally a named integer vector with repeat lengths by marker. Only needed when delta is of length two.}
}
\value{
Object of class \code{stutter_type} to be passed to \link{allele_specific_stutter_model}.
}
\description{
Defines a stutter type to be used in the allele specific stutter model.
}
\details{
When a pg_model is constructed (see \link{log_normal_model}), a stutter model can optionally be applied.
}
\examples{
filename_bs_exceptions <- system.file("extdata",
"GlobalFiler_Stutter_Exceptions_3500.csv",package = "simDNAmixtures")
bs_exceptions <- read_stutter_exceptions(filename_bs_exceptions)

filename_bs_regression <- system.file("extdata",
"GlobalFiler_Stutter_3500.txt",package = "simDNAmixtures")
bs_regression <- read_stutter_regression(filename_bs_regression)

backstutter <- stutter_type(name = "BackStutter", delta = -1,
                            stutter_regression = bs_regression,
                            stutter_exceptions = bs_exceptions)
}
