\name{Fsiland.lik}
\alias{Fsiland.lik}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Compute -(Log-likelihood) for models with different parameters for spatial influence functions.
}
\description{
This function allows to investigate some problem optimization for function Fsiland by plotting the -(log-likelihhod) 
for models with different parameters for spatial influence functions for landscape variables.

}
\usage{
Fsiland.lik(res, land,data, varnames = NULL, seqd = seq(2, 2000, length = 10))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{res}{
an object from Fsiland estimation
}
 \item{land}{
The landscape (a sf object) used to obtain the result res
}
  \item{data}{
the dataframe used to obtain the result res
}
 
  \item{varnames}{
landscape variables for which -(log-likelihhod) is studied. If varnames is null (by default), -(log-likelihhod) is investigated for 
all landscape variables in estimted model for object res.
}
  \item{seqd}{
a vector of positives values that represent different buffer sizes for the landscape variables.
}
}
\details{
Estimation based on log-likelihood aims to find parameters that maximises log-likelihood, that is to say 
that minimses -(log-likelihood). From graphics obtained with this fucntion, orange curve gives 
the -(log-likelihood) obtained for the estimatd model. Others curves gives -(log-likelihood) by varying 
buffer sizes for landscape variables. If minimisation for -(log-likelihood) for estimation 
given in object res, no curve should go below the ornage one.
%%  ~~ If necessary, more details than the description above ~~
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
A matrix with -(log-likelihood) values for the different landscape variables (argument varnames) and for the different buffer sizes (argument seqd).

}

\author{
%%  ~~who you are~~
O. Martin and F. Carpentier
}

%% ~Make other sections like Warning with \section{Warning }{....} ~


\examples{
\donttest{
data(dataSiland)
data(landSiland)
resF=Fsiland(obs~x1+L1+L2,data=dataSiland,land=landSiland,init = c(50),wd=20)
Fsiland.lik(resF,dataSiland,land=landSiland,varnames=c("L1","L2"),seqd=seq(5,500,length=20))
}
}



