% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laplace_matrix.R
\name{laplacian_angle}
\alias{laplacian_angle}
\title{Angle between Eigenvectors}
\usage{
laplacian_angle(g, type = "sign", ...)
}
\arguments{
\item{g}{input graph. Must have a sign edge attribute}

\item{type}{string. either "sign" for signed Laplacian or "complex" for complex Laplacian. Defaults to "sign"}

\item{...}{additional parameters for Laplacian matrix such as the attribute containing "P","N" and "A" for the complex Laplacian}
}
\value{
a numeric matrix
}
\description{
Computes the angle between eigenvectors of the signed or complex Laplacian.
}
\details{
angle between eigenvectors and zero.
}
\examples{
library(igraph)
g <- sample_islands_signed(3, 10, 5/10, 1)
laplacian_angle(g)
}
\author{
David Schoch
}
