% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_convert.R
\name{sig_convert}
\alias{sig_convert}
\title{Convert Signatures between different Genomic Distribution of Components}
\usage{
sig_convert(sig, from = "human-genome", to = "human-exome")
}
\arguments{
\item{sig}{a \code{Signature} object obtained either from \link{sig_extract} or \link{sig_auto_extract},
or just a raw signature matrix with row representing components (motifs) and
column representing signatures.}

\item{from}{either one of "human-genome" and "human-exome" or an opportunity matrix
(repeated \code{n} columns with each row represents the total number of mutations for
a component, \code{n} is the number of signature).}

\item{to}{same as \code{from}.}
}
\value{
a \code{matrix}.
}
\description{
Converts signatures between two representations relative to different sets of mutational opportunities.
Currently, only SBS signature is supported.
}
\details{
The default opportunity matrix for "human-genome" and "human-exome" comes from COSMIC
signature database v2 and v3.
}
\examples{
# Load SBS signature
load(system.file("extdata", "toy_mutational_signature.RData",
  package = "sigminer", mustWork = TRUE
))
# Exome-relative to Genome-relative
sig_converted <- sig_convert(sig2,
  from = "human-exome",
  to = "human-genome"
)
sig_converted

show_sig_profile(sig2, style = "cosmic")
show_sig_profile(sig_converted, style = "cosmic")
}
\references{
\code{convert_signatures} function from sigfit package.
}
