% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_cn_profile.R
\name{show_cn_profile}
\alias{show_cn_profile}
\title{Show Sample Copy Number Profile}
\usage{
show_cn_profile(
  data,
  samples = NULL,
  show_n = NULL,
  show_title = FALSE,
  chrs = paste0("chr", 1:22),
  genome_build = c("hg19", "hg38", "mm10"),
  nrow = NULL,
  ncol = NULL,
  return_plotlist = FALSE
)
}
\arguments{
\item{data}{a \link{CopyNumber} object or a \code{data.frame} containing at least 'chromosome', 'start',
'end', 'segVal' these columns.}

\item{samples}{default is NULL, can be a chracter vector representing multiple samples. If \code{data} argument
is a \code{data.frame}, a column called \code{sample} must exist.}

\item{show_n}{number of samples to show, this is used for checking.}

\item{show_title}{if \code{TRUE}, show title for multiple samples.}

\item{chrs}{chromosomes start with 'chr'.}

\item{genome_build}{genome build version, used when \code{data} is a \code{data.frame}, should be 'hg19' or 'hg38'.}

\item{nrow}{number of rows in the plot grid when multiple samples are selected.}

\item{ncol}{number of columns in the plot grid when multiple samples are selected.}

\item{return_plotlist}{default is \code{FALSE}, if \code{TRUE}, return a plot list instead of a combined plot.}
}
\value{
a \code{ggplot} object or a \code{list}
}
\description{
Sometimes it is very useful to check details about copy number profile for one or multiple
samples. This function is designed to do this job and can be further modified by \strong{ggplot2}
related packages.
}
\examples{
# Load copy number object
load(system.file("extdata", "toy_copynumber.RData",
  package = "sigminer", mustWork = TRUE
))

p <- show_cn_profile(cn, nrow = 2, ncol = 1)
p
}
