% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{sg_cluster}
\alias{sg_cluster}
\alias{sg_get_cluster}
\title{Cluster}
\usage{
sg_cluster(sg, colors = c("#B1E2A3", "#98D3A5", "#328983", "#1C5C70",
  "#24C96B"), directed = TRUE, algo = igraph::cluster_walktrap,
  quiet = !interactive(), ...)

sg_get_cluster(nodes, edges, colors = c("#B1E2A3", "#98D3A5", "#328983",
  "#1C5C70", "#24C96B"), directed = TRUE,
  algo = igraph::cluster_walktrap, quiet = !interactive(), ...)
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{colors}{Palette to color the nodes.}

\item{directed}{Whether or not to create a directed graph, passed to \code{\link[igraph]{graph_from_data_frame}}.}

\item{algo}{An \code{igraph} clustering function.}

\item{quiet}{Set to \code{TRUE} to print the number of clusters to the console.}

\item{...}{Any parameter to pass to \code{algo}.}

\item{nodes, edges}{Nodes and edges as prepared for sigmajs.}
}
\value{
\code{sg_get_cluster} returns nodes with \code{color} variable.
}
\description{
Color nodes by cluster.
}
\section{Functions}{

\itemize{
  \item{\code{sg_cluster} Color nodes by cluster.}
  \item{\code{sg_get_cluster} helper to get graph's nodes color by cluster.}
}
}

\examples{
nodes <- sg_make_nodes() 
edges <- sg_make_edges(nodes, 15)

sigmajs() \%>\% 
  sg_nodes(nodes, id, size) \%>\% 
  sg_edges(edges, id, source, target) \%>\% 
  sg_layout() \%>\% 
  sg_cluster() 
  
clustered <- sg_get_cluster(nodes, edges)

}
