% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showtext.R
\name{showtext_auto}
\alias{showtext_auto}
\alias{showtext.auto}
\title{Automatically Using 'showtext' for New Graphics Devices}
\usage{
showtext_auto(enable = TRUE)

showtext.auto(enable = TRUE)
}
\arguments{
\item{enable}{\code{TRUE} to turn on and \code{FALSE} to turn off}
}
\description{
The two versions of this function are equivalent, but the
"underscore" naming is preferred.

This function could turn on/off the automatic use of \pkg{showtext}
functionality. If turned on, any newly opened graphics devices will use
\pkg{showtext} to draw text. This helps to avoid the repeated calls of
\code{\link{showtext_begin}()} and \code{\link{showtext_end}()}.
}
\examples{
\dontrun{
pdf("test1.pdf")
plot(1, main = "\\u6b22\\u8fce")  ## may not render properly
dev.off()

## Automatically use showtext for future devices
showtext_auto()
plot(1, main = "\\u6b22\\u8fce", family = "wqy-microhei")

pdf("test2.pdf")
plot(1, main = "\\u6b22\\u8fce", family = "wqy-microhei")
dev.off()

## Turn off if needed
showtext_auto(FALSE)
}
}
\seealso{
\code{\link{showtext_begin}()}, \code{\link{showtext_end}()}
}
\author{
Yixuan Qiu <\url{https://statr.me/}>
}
