\name{rangeStat}
\alias{rangeStat}
\alias{pRangeStat}
\alias{qRangeStat}
\alias{rRangeStat}
\title{Distribution of range statistics}
\description{
Approximate cumulative distribution function, quantile function and random deviates of range statistics based on a lookup table generated by simulations. Includes extreme spread (ES), figure of merit (FoM), bounding box diagonal (D). This function assumes a circular bivariate normal shot distribution with 0 mean.
}
\usage{
pRangeStat(q, sigma = 1, nPerGroup = 5, nGroups = 1, stat = c("ES", "FoM", "D"),
           lower.tail = TRUE, loUp)
qRangeStat(p, sigma = 1, nPerGroup = 5, nGroups = 1, stat = c("ES", "FoM", "D"),
           method = c("linear", "spline"), lower.tail = TRUE)
rRangeStat(n, sigma = 1, nPerGroup = 5, nGroups = 1, stat = c("ES", "FoM", "D"))
}
\arguments{
  \item{q}{vector of quantiles.}
  \item{p}{vector of probabilities. Must be within [0.005, 0.995].}
  \item{n}{number of observations. Must be <= 100. If \code{length(n) > 1}, the length is taken to be the number required.}
  \item{stat}{character string indicating the range statistic. One of \code{"ES"} (extreme spread), \code{"FoM"} (figure of merit), or \code{"D"} (bounding box diagonal).}
  \item{nPerGroup}{integer between 2 and 100. Number of shots in each group.}
  \item{nGroups}{integer between 1 and 10. Number of groups. For \code{nGroups} > 1, the quantile of the average range statistic is returned.}
  \item{sigma}{numeric value > 0 indicating the Rayleigh scale parameter (common standard deviation of the underlying normal distribution of each 2D-coordinate). See \code{\link[shotGroups]{Rayleigh}}.}
  \item{lower.tail}{logical. If \code{TRUE} (default), probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}
  \item{method}{method for bivariate interpolation if both, \code{p} and \code{nPerGroup}, are missing from the lookup table. \code{"linear"} for bilinear interpolation (requires installing package \code{interp}), \code{"spline"} for bivariate spline approximation (requires installing package \code{MBA}).}
  \item{loUp}{search interval for numerical root finding. A vector with the lower and upper interval boundary. See details.}
}
\details{
Based on the lookup table \code{\link[shotGroups]{DFdistr}} with results form a Monte Carlo simulation. If the value either for \code{p} or for \code{nPerGroup} is missing from the lookup table, a monotone spline interpolation between the neighboring simulated values is used.

\code{pRangeStat} is implemented through numerical root finding of \code{qRangeStat}. If no search interval for \code{\link[stats]{uniroot}} is provided, whole interval of probabilities available in \code{\link[shotGroups]{DFdistr}} is used. \code{NA} is returned for quantiles corresponding to probabilities outside of the available range.
}
\value{
\code{pRangeStat} gives the cumulative distribution function, \code{qRangeStat} gives the quantile function, \code{rRangeStat} generates random deviates.}
\references{
\url{http://ballistipedia.com/index.php?title=Range_Statistics}
}
\seealso{
\code{\link[shotGroups]{DFdistr}},
\code{\link[shotGroups]{range2sigma}},
\code{\link[shotGroups]{Rayleigh}},
\code{\link[interp]{interp}},
\code{\link[MBA]{mba.surf}},
}
\examples{
(q45 <- pRangeStat(c(4, 5), sigma=1.5, n=5, nGroups=3, stat="ES"))

# should be the 4 and 5
qRangeStat(q45, sigma=1.5, n=5, nGroups=3, stat="ES")

rRangeStat(5, sigma=2, nPerGroup=5, nGroups=3, stat="D")
}
\keyword{distribution}
