% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assets.R
\name{assets_install_copy}
\alias{assets_install_copy}
\alias{assets_install_link}
\title{Install shinylive assets from from a local directory}
\usage{
assets_install_copy(
  assets_repo_dir,
  ...,
  dir = assets_cache_dir(),
  version = package_json_version(assets_repo_dir)
)

assets_install_link(
  assets_repo_dir,
  ...,
  dir = assets_cache_dir(),
  version = package_json_version(assets_repo_dir)
)
}
\arguments{
\item{assets_repo_dir}{The local repository directory for shinylive assets
(e.g. \href{https://github.com/posit-dev/py-shinylive}{\code{posit-dev/shinylive}})}

\item{...}{Ignored.}

\item{dir}{The asset cache directory. Unless testing, the default behavior
should be used.}

\item{version}{The version of the assets being installed.}
}
\value{
All method return \code{invisible()}.
}
\description{
Helper methods for testing updates to shinylive assets.
}
\section{Functions}{
\itemize{
\item \code{assets_install_copy()}: Copies all shinylive assets from a local shinylive
repository (e.g.
\href{https://github.com/posit-dev/py-shinylive}{\code{posit-dev/shinylive}}). This
must be repeated for any change in the assets.

\item \code{assets_install_link()}: Creates a symlink of the local shinylive assets to the
cached assets directory. After the first installation, the assets will the
same as the source due to the symlink.

}}
\seealso{
\code{\link[=assets_download]{assets_download()}}, \code{\link[=assets_ensure]{assets_ensure()}}, \code{\link[=assets_cleanup]{assets_cleanup()}}
}
