% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export}
\alias{export}
\title{Export a Shiny app to a directory}
\usage{
export(appdir, destdir, ..., subdir = "", verbose = is_interactive())
}
\arguments{
\item{appdir}{Directory containing the application.}

\item{destdir}{Destination directory.}

\item{...}{Ignored}

\item{subdir}{Subdirectory of \code{destdir} to write the app to.}

\item{verbose}{Print verbose output. Defaults to \code{TRUE} if running
interactively.}
}
\value{
Nothing. The app is exported to \code{destdir}. Instructions for serving
the directory are printed to stdout.
}
\description{
This function exports a Shiny app to a directory, which can then be served
using \code{httpuv}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
app_dir <- system.file("examples", "01_hello", package = "shiny")
out_dir <- tempfile("shinylive-export")

# Export the app to a directory
export(app_dir, out_dir)

# Serve the exported directory
if (require(httpuv)) {
  httpuv::runStaticServer(out_dir)
}
\dontshow{\}) # examplesIf}
}
