% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinylight.R
\name{slRunRServer}
\alias{slRunRServer}
\title{Start a ShinyLight server which runs R that it is sent}
\usage{
slRunRServer(
  permittedSymbols,
  appDir = NULL,
  host = "127.0.0.1",
  port = NULL,
  daemonize = FALSE,
  initialize = NULL
)
}
\arguments{
\item{permittedSymbols}{List of symbols that are permitted in the R
commands passed. Remember to include \code{data}, \code{$} and
\code{<-}.}

\item{appDir}{Directory containing files to serve (for example
system.file("www", package = "your-package"))}

\item{host}{IP address to listen on, default is \code{"127.0.0.1"}
(localhost). Use \code{"0.0.0.0"} to run in a docker container.}

\item{port}{Internet port of the virtual server. If not defined, a
random free port will be chosen and the browser will be opened
to show the GUI.}

\item{daemonize}{If TRUE, keep serving forever without returning.
This is useful when called from \code{RScript}, to keep}

\item{initialize}{A json string or list (that will be converted to a
JSON string) to be passed to the JavaScript as initial data. The
index.html must contain a line containing
\code{var shinylight_initial_data=}, which will be replaced with
code that sets \code{shinylight_initial_data} to this supplied JSON
string.}
}
\value{
server object, unless daemonize is TRUE.
}
\description{
Start a ShinyLight server which runs R that it is sent
}
\examples{
server <- slRunRServer(
  permitted = list("*"),
  port = 50053
)
# Normally we would use shinylight.js to send the function over
# and receive the result, not R and websocket.
ws <- websocket::WebSocket$new("ws://127.0.0.1:50053/x")
resultdata <- NULL
ws$onMessage(function(event) {
  resultdata <<- jsonlite::fromJSON(event$data)$result$data
})
ws$onOpen(function(event) {
  ws$send('{"method":"runR","params":{"Rcommand":"3 * 57"}}')
})
timeout = 30
while(is.null(resultdata) && 0 < timeout) {
  later::run_now()
  Sys.sleep(0.1)
  timeout <- timeout - 1
}
ws$close()
slStop(server)
stopifnot(resultdata == 171)  # 3 * 57 == 171
grDevices::png()  # workaround; you do not have to do this
}
\seealso{
\code{\link{slServer}} for the more general form of this
function, or \code{\link{slStop}} to stop a running server.
\code{\link{shinylight.runR}} is the JavaScript function you need
to call to pass R code from the browser to the server.
}
