% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertical-tab.R
\name{updateVerticalTabsetPanel}
\alias{updateVerticalTabsetPanel}
\title{Update selected vertical tab}
\usage{
updateVerticalTabsetPanel(session, inputId, selected = NULL)
}
\arguments{
\item{session}{The \code{session} object passed to function given to \code{shinyServer.}}

\item{inputId}{The id of the \code{verticalTabsetPanel} object.}

\item{selected}{The name of the tab to make active.}
}
\description{
Update selected vertical tab
}
\examples{

if (interactive()) {

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  fluidRow(
    column(
      width = 10, offset = 1,
      tags$h2("Update vertical tab panel example:"),
      verbatimTextOutput("res"),
      radioButtons(
        inputId = "update", label = "Update selected:",
        choices = c("Title 1", "Title 2", "Title 3"),
        inline = TRUE
      ),
      verticalTabsetPanel(
        id = "TABS",
        verticalTabPanel(
          title = "Title 1", icon = icon("home", "fa-2x"),
          "Content panel 1"
        ),
        verticalTabPanel(
          title = "Title 2", icon = icon("map", "fa-2x"),
          "Content panel 2"
        ),
        verticalTabPanel(
          title = "Title 3", icon = icon("rocket", "fa-2x"),
          "Content panel 3"
        )
      )
    )
  )
)

server <- function(input, output, session) {
  output$res <- renderPrint(input$TABS)
  observeEvent(input$update, {
    shinyWidgets:::updateVerticalTabsetPanel(
      session = session,
      inputId = "TABS",
      selected = input$update
    )
  }, ignoreInit = TRUE)
}

shinyApp(ui, server)

}

}
\seealso{
\code{\link{verticalTabsetPanel}}
}
