% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-icon.R
\name{updateTextInputIcon}
\alias{updateTextInputIcon}
\title{Change the value of a text input icon on the client}
\usage{
updateTextInputIcon(
  session,
  inputId,
  label = NULL,
  value = NULL,
  placeholder = NULL
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{placeholder}{The placeholder to set for the input object.}
}
\value{
No value.
}
\description{
Change the value of a text input icon on the client
}
\examples{
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  textInputIcon(
    inputId = "ex1",
    label = "With an icon",
    icon = icon("user-circle-o")
  ),
  actionButton("update", "Random value")
)

server <- function(input, output, session) {

  observeEvent(input$update, {
    updateTextInputIcon(
      session = session,
      inputId = "ex1",
      value = paste(sample(letters, 8), collapse = "")
    )
  })

}

if (interactive())
  shinyApp(ui, server)
}
