% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Select}
\alias{f7Select}
\alias{updateF7Select}
\title{Framework7 select input}
\usage{
f7Select(
  inputId,
  label,
  choices,
  selected = NULL,
  width = NULL,
  style = list(media = NULL, description = NULL, outline = FALSE)
)

updateF7Select(
  inputId,
  selected = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{Text input id.}

\item{label}{Text input label.}

\item{choices}{Select input choices.}

\item{selected}{Select input default selected value.}

\item{width}{The width of the input, e.g. \code{400px}, or \code{100\%}.}

\item{style}{Input style. A list with media (image or icon),
description (text), floating, outline and clearable (booleans).}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
\code{f7Select} creates a select input.

\code{updateF7Select} changes the value of a select input on the client
}
\note{
Contrary to \link{f7Text}, \link{f7Select} can't be cleared and
label can't float.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "f7Select",
    f7SingleLayout(
      navbar = f7Navbar(title = "updateF7Select"),
      f7Card(
        f7Button(inputId = "update", label = "Update select"),
        br(),
        f7List(
          f7Select(
            inputId = "select",
            label = "Choose a variable:",
            choices = colnames(mtcars)[-1],
            selected = "hp",
            style = list(
              description = "A basic select input",
              media = f7Icon("car_fill"),
              outline = TRUE
            )
          )
        ),
        verbatimTextOutput("test")
      )
    )
  ),
  server = function(input, output, session) {
    output$test <- renderPrint(input$select)

    observeEvent(input$update, {
      updateF7Select(
        inputId = "select",
        selected = "gear"
      )
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
