% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Select}
\alias{f7Select}
\alias{updateF7Select}
\title{Framework7 select input}
\usage{
f7Select(inputId, label, choices, selected = NULL, width = NULL)

updateF7Select(
  inputId,
  selected = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{label}{Select input label.}

\item{choices}{Select input choices.}

\item{selected}{New value.}

\item{width}{The width of the input, e.g. \code{400px}, or \code{100\%}.}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
\link{f7Select} creates a select input.

\link{updateF7Select} changes the value of a select input on the client
}
\examples{
# Select input
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
      navbar = f7Navbar(title = "f7Select"),
      f7Select(
       inputId = "variable",
       label = "Choose a variable:",
       choices = colnames(mtcars)[-1],
       selected = "hp"
      ),
      tableOutput("data")
     )
   ),
   server = function(input, output) {
     output$data <- renderTable({
       mtcars[, c("mpg", input$variable), drop = FALSE]
     }, rownames = TRUE)
   }
 )
}
# Update select input
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
       navbar = f7Navbar(title = "updateF7Select"),
       f7Card(
         f7Button(inputId = "update", label = "Update select"),
         br(),
         f7Select(
          inputId = "variable",
          label = "Choose a variable:",
          choices = colnames(mtcars)[-1],
          selected = "hp"
         ),
         verbatimTextOutput("test")
       )
     )
   ),
   server = function(input, output, session) {

     output$test <- renderPrint(input$variable)

     observeEvent(input$update, {
       updateF7Select(
         inputId = "variable",
         selected = "gear"
       )
     })
   }
 )
}
}
