% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-update-inputs.R
\name{updateF7SmartSelect}
\alias{updateF7SmartSelect}
\title{Change the value of a smart select input on the client}
\usage{
updateF7SmartSelect(
  inputId,
  selected = NULL,
  ...,
  multiple = NULL,
  maxLength = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{selected}{The new value for the input.}

\item{...}{Parameters used to update the smart select,
use same arguments as in \code{\link{f7SmartSelect}}.}

\item{multiple}{Whether to allow multiple values.}

\item{maxLength}{Maximum items to select when multiple is TRUE.}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
Change the value of a smart select input on the client
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "My app",
    f7SingleLayout(
      navbar = f7Navbar(title = "Update f7SmartSelect"),
      f7Button("updateSmartSelect", "Update Smart Select"),
      f7SmartSelect(
        inputId = "variable",
        label = "Choose a variable:",
        selected = "drat",
        choices = colnames(mtcars)[-1],
        openIn = "popup"
      ),
      tableOutput("data")
    )
  ),
  server = function(input, output, session) {
    output$data <- renderTable({
      mtcars[, c("mpg", input$variable), drop = FALSE]
    }, rownames = TRUE)

    observeEvent(input$updateSmartSelect, {
      updateF7SmartSelect(
        inputId = "variable",
        openIn = "sheet",
        selected = "cyl",
        multiple = TRUE,
        maxLength = 3
      )
    })
  }
 )
}
}
