% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Fab.R
\name{f7Fabs}
\alias{f7Fabs}
\title{Create a Framework7 container for floating action button (FAB)}
\usage{
f7Fabs(
  ...,
  id = NULL,
  position = c("right-top", "right-center", "right-bottom", "left-top", "left-center",
    "left-bottom", "center-center", "center-top", "center-bottom"),
  color = NULL,
  extended = FALSE,
  label = NULL,
  sideOpen = c("left", "right", "top", "bottom", "center"),
  morph = FALSE,
  morphTarget = NULL
)
}
\arguments{
\item{...}{Slot for \link{f7Fab}.}

\item{id}{Optional: access the current state of the \link{f7Fabs} container.}

\item{position}{Container position.}

\item{color}{Container color.}

\item{extended}{If TRUE, the FAB will be wider. This allows to use a label (see below).}

\item{label}{Container label. Only if extended is TRUE.}

\item{sideOpen}{When the container is pressed, indicate where buttons are displayed.}

\item{morph}{Whether to allow the FAB to transofrm into another UI element.}

\item{morphTarget}{CSS selector of the morph target: \code{".toolbar"} for instance.}
}
\description{
Build a Framework7 container for floating action button (FAB)
}
\note{
The background color might be an issue depending on the parent container. Consider
it experimental.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
  ui = f7Page(
    color = "pink",
    title = "Floating action buttons",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Fabs"),
     f7Fabs(
      extended = TRUE,
      label = "Menu",
      position = "center-top",
      color = "yellow",
      sideOpen = "right",
      lapply(1:4, function(i) f7Fab(paste0("btn", i), i))
    ),
    lapply(1:4, function(i) verbatimTextOutput(paste0("res", i))),

    f7Fabs(
      position = "center-center",
      color = "purple",
      sideOpen = "center",
      lapply(5:8, function(i) f7Fab(paste0("btn", i), i))
    ),
    lapply(5:8, function(i) verbatimTextOutput(paste0("res", i))),

    f7Fabs(
      position = "left-bottom",
      color = "pink",
      sideOpen = "top",
      lapply(9:12, function(i) f7Fab(paste0("btn", i), i))
    )
    )

  ),
  server = function(input, output) {
    lapply(1:12, function(i) {
      output[[paste0("res", i)]] <- renderPrint(input[[paste0("btn", i)]])
    })
  }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
