% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abstract_aggregator.R
\docType{class}
\name{abstract_aggregator}
\alias{abstract_aggregator}
\title{R6 super class for the aggregation}
\format{
An \code{R6::R6Class} object
}
\description{
An abstract class for the aggregation,
which defines the structure of the class and
is not available on a stand-alone basis.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{interleave_gaps}}{Whether \code{NA} values should be added
when there are gaps / irregularly sampled data}

\item{\code{accepted_datatype}}{Vector of supported data classes}

\item{\code{nan_position}}{Character that indicates
where \code{NA}s are placed when gaps are detected}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-abstract_aggregator-new}{\code{abstract_aggregator$new()}}
\item \href{#method-abstract_aggregator-aggregate}{\code{abstract_aggregator$aggregate()}}
\item \href{#method-abstract_aggregator-clone}{\code{abstract_aggregator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-abstract_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-abstract_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of abstract_aggregator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{abstract_aggregator$new(
  interleave_gaps = FALSE,
  nan_position = "end",
  accepted_datatype = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interleave_gaps}}{Boolean, optional.
Whether \code{NA} values should be added
when there are gaps / irregularly sampled data.
A quantile-based approach is employed.
By default, \code{FALSE}.}

\item{\code{nan_position}}{Character, optional.
Indicates where \code{NA}s are placed when gaps are detected.
If \code{"end"}, the first point after a gap will be replaced.
If \code{"begin"}, the last point before a gap will be replaced.
If \code{"both"}, both the encompassing gap data points are replaced.
This parameter is only effective
when \code{interleave_gaps == TRUE}.}

\item{\code{accepted_datatype}}{Character vector, optional.
This parameter indicates the supported data classes.
If all data classes are accepted, set it to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-abstract_aggregator-aggregate"></a>}}
\if{latex}{\out{\hypertarget{method-abstract_aggregator-aggregate}{}}}
\subsection{Method \code{aggregate()}}{
Aggregates the given input and returns samples.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{abstract_aggregator$aggregate(x, y, n_out)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x, y}}{Indexes and values that has to be aggregated.}

\item{\code{n_out}}{Integer.
The number of samples that the aggregated data contains.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-abstract_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-abstract_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{abstract_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
