% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\docType{data}
\name{NS}
\alias{NS}
\alias{ns.sep}
\title{Namespaced IDs for inputs/outputs}
\format{
An object of class \code{character} of length 1.
}
\usage{
NS(namespace, id = NULL)

ns.sep
}
\arguments{
\item{namespace}{The character vector to use for the namespace. This can have
any length, though a single element is most common. Length 0 will cause the
\code{id} to be returned without a namespace, and length 2 will be
interpreted as multiple namespaces, in increasing order of specificity
(i.e. starting with the top-level namespace).}

\item{id}{The id string to be namespaced (optional).}
}
\value{
If \code{id} is missing, returns a function that expects an id string
as its only argument and returns that id with the namespace prepended.
}
\description{
The \code{NS} function creates namespaced IDs out of bare IDs, by joining
them using \code{ns.sep} as the delimiter. It is intended for use in Shiny
modules. See \url{https://shiny.rstudio.com/articles/modules.html}.
}
\details{
Shiny applications use IDs to identify inputs and outputs. These IDs must be
unique within an application, as accidentally using the same input/output ID
more than once will result in unexpected behavior. The traditional solution
for preventing name collisions is \emph{namespaces}; a namespace is to an ID
as a directory is to a file. Use the \code{NS} function to turn a bare ID
into a namespaced one, by combining them with \code{ns.sep} in between.
}
\seealso{
\url{https://shiny.rstudio.com/articles/modules.html}
}
\keyword{datasets}
