% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notifications.R
\name{showNotification}
\alias{showNotification}
\alias{removeNotification}
\title{Show or remove a notification}
\usage{
showNotification(ui, action = NULL, duration = 5, closeButton = TRUE,
  id = NULL, type = c("default", "message", "warning", "error"),
  session = getDefaultReactiveDomain())

removeNotification(id, session = getDefaultReactiveDomain())
}
\arguments{
\item{ui}{Content of message.}

\item{action}{Message content that represents an action. For example, this
could be a link that the user can click on. This is separate from \code{ui}
so customized layouts can handle the main notification content separately
from action content.}

\item{duration}{Number of seconds to display the message before it
disappears. Use \code{NULL} to make the message not automatically
disappear.}

\item{closeButton}{If \code{TRUE}, display a button which will make the
notification disappear when clicked. If \code{FALSE} do not display.}

\item{id}{A unique identifier for the notification.

\code{id} is optional for \code{showNotification()}: Shiny will automatically create
one if needed. If you do supply it, Shiny will update an existing
notification if it exists, otherwise it will create a new one.

\code{id} is required for \code{removeNotification()}.}

\item{type}{A string which controls the color of the notification. One of
"default" (gray), "message" (blue), "warning" (yellow), or "error" (red).}

\item{session}{Session object to send notification to.}
}
\value{
An ID for the notification.
}
\description{
These functions show and remove notifications in a Shiny application.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
# Show a message when button is clicked
shinyApp(
  ui = fluidPage(
    actionButton("show", "Show")
  ),
  server = function(input, output) {
    observeEvent(input$show, {
      showNotification("Message text",
        action = a(href = "javascript:location.reload();", "Reload page")
      )
    })
  }
)

# App with show and remove buttons
shinyApp(
  ui = fluidPage(
    actionButton("show", "Show"),
    actionButton("remove", "Remove")
  ),
  server = function(input, output) {
    # A queue of notification IDs
    ids <- character(0)
    # A counter
    n <- 0

    observeEvent(input$show, {
      # Save the ID for removal later
      id <- showNotification(paste("Message", n), duration = NULL)
      ids <<- c(ids, id)
      n <<- n + 1
    })

    observeEvent(input$remove, {
      if (length(ids) > 0)
        removeNotification(ids[1])
      ids <<- ids[-1]
    })
  }
)
}
}
