% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_input.R
\name{date_input}
\alias{date_input}
\alias{dateInput}
\title{Define simple date input with Semantic UI styling}
\usage{
date_input(
  input_id,
  label = NULL,
  value = NULL,
  min = NULL,
  max = NULL,
  style = NULL,
  icon_name = "calendar"
)

dateInput(
  inputId,
  label = NULL,
  icon = NULL,
  value = NULL,
  min = NULL,
  max = NULL,
  width = NULL,
  ...
)
}
\arguments{
\item{input_id}{Input id.}

\item{label}{Label to be displayed with date input.}

\item{value}{Default date chosen for input.}

\item{min}{Minimum date that can be selected.}

\item{max}{Maximum date that can be selected.}

\item{style}{Css style for widget.}

\item{icon_name}{Icon that should be displayed on widget.}

\item{inputId}{Input id.}

\item{icon}{Icon that should be displayed on widget.}

\item{width}{character width of the object}

\item{...}{other arguments}
}
\description{
Define simple date input with Semantic UI styling
}
\examples{
if (interactive()) {
# Below example shows how to implement simple date range input using \code{date_input}

library(shiny)
library(shiny.semantic)

ui <- shinyUI(
  semanticPage(
    title = "Date range example",
    uiOutput("date_range"),
    p("Selected dates:"),
    textOutput("selected_dates")
  )
)

server <- shinyServer(function(input, output, session) {
  output$date_range <- renderUI({
    tagList(
      tags$div(tags$div(HTML("From")),
               date_input("date_from", value = Sys.Date() - 30, style = "width: 10\%;")),
      tags$div(tags$div(HTML("To")),
               date_input("date_to", value = Sys.Date(), style = "width: 10\%;"))
    )
  })

  output$selected_dates <- renderPrint({
    c(input$date_from, input$date_to)
  })
})

shinyApp(ui = ui, server = server)
}

}
