% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{flow_layout}
\alias{flow_layout}
\alias{flowLayout}
\title{Flow layout}
\usage{
flow_layout(
  ...,
  cell_args = list(),
  cell_width = "208px",
  column_gap = "12px",
  row_gap = "0px"
)

flowLayout(..., cellArgs = list())
}
\arguments{
\item{...}{Unnamed arguments will become child elements of the layout.
Named arguments will become HTML attributes on the outermost tag.}

\item{cell_args}{Any additional attributes that should be used for each cell
of the layout.}

\item{cell_width}{The width of the cells.}

\item{column_gap}{The spacing between columns.}

\item{row_gap}{The spacing between rows.}

\item{cellArgs}{Same as \code{cell_args}.}
}
\description{
Lays out elements in a left-to-right, top-to-bottom arrangement.
The elements on a given row will be top-aligned with each other.
}
\details{
The width of the elements and spacing between them is configurable.
Lengths can be given as numeric values (interpreted as pixels)
or character values (interpreted as CSS lengths).
With the default settings this layout closely resembles the \code{flowLayout}
from Shiny.
}
\examples{
if (interactive()) {
  ui <- semanticPage(
    flow_layout(
      numericInput("rows", "How many rows?", 5),
      selectInput("letter", "Which letter?", LETTERS),
      sliderInput("value", "What value?", 0, 100, 50)
    )
  )
  shinyApp(ui, server = function(input, output) {})
}
}
