% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegLogConnector.R
\docType{class}
\name{RegLogConnector}
\alias{RegLogConnector}
\title{RegLog connector template}
\description{
Parent class for all RegLog connectors
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{module_id}}{character vector specifying the automatically-generated
module_id for listener server module}

\item{\code{listener}}{reactiveVal that the object keeps listening of changes for}

\item{\code{message}}{reactiveVal containing outward message}

\item{\code{log}}{list containing data about received and sent messages by the object}

\item{\code{handlers}}{named list containing functions used to handle different
types of \code{RegLogConnectorMessage}. Name of the element corresponds to
the 'type' that is should handle.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-get_logs}{\code{RegLogConnector$get_logs()}}
\item \href{#method-new}{\code{RegLogConnector$new()}}
\item \href{#method-suspend}{\code{RegLogConnector$suspend()}}
\item \href{#method-resume}{\code{RegLogConnector$resume()}}
\item \href{#method-clone}{\code{RegLogConnector$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_logs"></a>}}
\if{latex}{\out{\hypertarget{method-get_logs}{}}}
\subsection{Method \code{get_logs()}}{
Function to receive all saved logs from the object in the form
of single data.frame
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogConnector$get_logs()}\if{html}{\out{</div>}}
}

\subsection{Details}{
You can specify custom handler functions as a named list passed
to \code{custom_handlers} arguments during object initialization. Custom handler
should take arguments: \code{self} and \code{private} - relating to the R6 object
and \code{message} of class \code{RegLogConnectorMessage}. It should return
return \code{RegLogConnectorMessage} object
}

\subsection{Returns}{
data.frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialization of the object. Sets up listener reactiveVal
and initializes listening server module
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogConnector$new(custom_handlers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{custom_handlers}}{named list of custom handler functions. Custom handler
should take arguments: \code{self} and \code{private} - relating to the R6 object
and \code{message} of class \code{RegLogConnectorMessage}. It should return
return \code{RegLogConnectorMessage} object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object of \code{RegLogConnector} class
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-suspend"></a>}}
\if{latex}{\out{\hypertarget{method-suspend}{}}}
\subsection{Method \code{suspend()}}{
Suspend the listening to the changes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogConnector$suspend()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resume"></a>}}
\if{latex}{\out{\hypertarget{method-resume}{}}}
\subsection{Method \code{resume()}}{
Resume the listening to the changes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogConnector$resume()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogConnector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
