% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{htmlElements}
\alias{htmlElements}
\alias{H1}
\alias{H2}
\alias{H3}
\alias{H4}
\alias{H5}
\alias{H6}
\alias{Blockquote}
\alias{Code}
\alias{Pre}
\alias{OL}
\alias{UL}
\title{HTML elements}
\usage{
H1(...)

H2(...)

H3(...)

H4(...)

H5(...)

H6(...)

Blockquote(...)

Code(...)

Pre(...)

OL(...)

UL(...)
}
\arguments{
\item{...}{Component props and children. See the official Blueprint docs for details.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Documentation: \url{https://blueprintjs.com/docs/#core/components/html}
}
\examples{
library(shiny.blueprint)
library(shiny)

ui <- function(id) {
  tagList(
    H1("H1"),
    H2("H2"),
    H3("H3"),
    H4("H4"),
    H5("H5"),
    H6("H6"),
    Blockquote("Blockquote"),
    Code("Code"),
    Label("Label"),
    Pre("Pre"),
    OL(tags$li("OL")),
    UL(tags$li("UL"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {})
}

if (interactive()) shinyApp(ui("app"), function(input, output) server("app"))
}
\seealso{
Other HTML elements: 
\code{\link{HTMLTable}()},
\code{\link{Label}()}
}
\concept{HTML elements}
