% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{TagInput}
\alias{TagInput}
\alias{TagInput.shinyInput}
\title{TagInput}
\usage{
TagInput(...)

TagInput.shinyInput(inputId, ..., value = defaultValue)
}
\arguments{
\item{...}{Component props and children. See the official Blueprint docs for details.}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{value}{Initial value.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Documentation: \url{https://blueprintjs.com/docs/#core/components/tag-input}
}
\examples{
library(shiny)
library(shiny.blueprint)


ui <- function(id) {
  ns <- NS(id)
  tagList(
    TagInput.shinyInput(
      inputId = ns("value"),
      value = c("one", "two", "three")
    ),
    textOutput(ns("valueOutput"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    output$valueOutput <- renderText(input$value)
  })
}

if (interactive()) shinyApp(ui("app"), function(input, output) server("app"))
}
