% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{progressOutput}
\alias{progressOutput}
\alias{renderProgress}
\title{Progress bar in shiny dashboard}
\usage{
progressOutput(
  outputId,
  ...,
  description = "Initializing",
  width = "100\%",
  class = "bg-primary",
  value = 0,
  size = c("md", "sm", "xs")
)

renderProgress(expr, env = parent.frame(), quoted = FALSE, outputArgs = list())
}
\arguments{
\item{outputId}{the element id of the progress}

\item{...}{extra elements on the top of the progress bar}

\item{description}{descriptive message below the progress bar}

\item{width}{width of the progress}

\item{class}{progress class, default is \code{"bg-primary"}}

\item{value}{initial value, ranging from 0 to 100; default is 0}

\item{size}{size of the progress bar; choices are \code{"md"}, \code{"sm"},
\code{"xs"}}

\item{expr}{R expression that should return a named list of \code{value} and
\code{description}}

\item{env}{where to evaluate \code{expr}}

\item{quoted}{whether \code{expr} is quoted}

\item{outputArgs}{a list of other parameters in \code{progressOutput}}
}
\value{
\code{progressOutput} returns 'HTML' tags containing progress bars
that can be rendered later via \code{\link{shiny_progress}} or
\code{renderProgress}. \code{renderProgress} returns shiny render functions
internally.
}
\description{
For detailed usage, see demo application by
running \code{render()}.
}
\examples{

library(shiny)
library(shidashi)
progressOutput("sales_report_prog1",
               description = "6 days left!",
               "Add Products to Cart",
               span(class="float-right", "123/150"),
               value = 123/150 * 100)

# server function
server <- function(input, output, session, ...){
  output$sales_report_prog1 <- renderProgress({
    return(list(
      value = 140 / 150 * 100,
      description = "5 days left!"
    ))
  })
}

}
