% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monthlyWB.R
\name{monthlyWB}
\alias{monthlyWB}
\alias{monthlyWB_summary}
\title{Monthly Water Balances}
\usage{
monthlyWB(
  AWC,
  PPT,
  PET,
  S_init = 1,
  starting_month = 1,
  rep = 1,
  keep_last = FALSE
)

monthlyWB_summary(w)
}
\arguments{
\item{AWC}{available water-holding capacity (mm), typically thickness (mm) * awc (fraction)}

\item{PPT}{time-series of monthly PPT (mm), calendar year ordering}

\item{PET}{time-series of monthly PET (mm), calendar year ordering}

\item{S_init}{initial fraction of \code{AWC} filled with water (values 0-1)}

\item{starting_month}{starting month index, 1=January, 9=September}

\item{rep}{number of cycles to run water balance}

\item{keep_last}{keep only the last iteration of the water balance}

\item{w}{used for for \code{monthlyWB_summary()}: a data.frame, such as result of \code{monthlyWB()};}
}
\value{
a \code{data.frame} with the following elements:

\itemize{
\item{PPT: }{monthly PPT (mm)}
\item{PET: }{monthly PET (mm)}
\item{U: }{monthly surplus (mm)}
\item{S: }{monthly soil moisture storage (mm)}
\item{ET: }{monthly AET (mm)}
\item{D: }{monthly deficit (mm)}
\item{month: }{month number}
\item{mo: }{month label}
}

\code{monthlyWB_summary()}: a \code{data.frame} containing:
\itemize{
\item cumulative (\code{dry}, \code{moist}, \code{wet}) days
\item consecutive (\code{dry_con}, \code{moist_con}, \code{wet_con}) days
\item total deficit (\code{total_deficit}) in mm
\item total surplus (\code{total_surplus}) in mm
\item total actual evapotranspiration (\code{total_AET}) in mm
\item annual actual evapotranspiration to potential evapotranspiration ratio (\code{annual_AET_PET_ratio})
}
}
\description{
Perform a monthly water balance by "leaky bucket" model, inspired by code from \code{bucket.sim} of \code{hydromad} package, as defined in Bai et al., (2009) (model "SMA_S1"). The plant available water-holding storage (soil thickness * awc) is used as the "bucket capacity". All water in excess of this capacity is lumped into a single "surplus" term.
}
\details{
See the \href{http://ncss-tech.github.io/AQP/sharpshootR/monthly-WB.html}{monthly water balance tutorial} for further examples and discussion.

A number of important assumptions are made by this style of water balance modeling:
\itemize{
\item the concept of field capacity is built into the specified bucket size
\item the influence of aquitards or local terrain cannot be integrated into this model
\item interception is not used in this model
}
}
\references{
Arkley R, Ulrich R. 1962. The use of calculated actual and potential evapotranspiration for estimating potential plant growth. Hilgardia 32(10):443-469.

Bai, Y., T. Wagener, P. Reed (2009). A top-down framework for watershed model evaluation and selection under uncertainty. Environmental Modelling and Software 24(8), pp. 901-916.

Farmer, D., M. Sivapalan, Farmer, D. (2003). Climate, soil and vegetation controls upon the variability of water balance in temperate and semiarid landscapes: downward approach to water balance analysis. Water Resources Research 39(2), p 1035.
}
