% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{TuneExplainedVarianceCov}
\alias{TuneExplainedVarianceCov}
\title{Tuning function (covariance)}
\usage{
TuneExplainedVarianceCov(u, ev_xx = NULL, lambda)
}
\arguments{
\item{u}{constant u added to the diagonal of the precision matrix.}

\item{ev_xx}{desired proportion of explained variance. If \code{ev_xx=NULL}, the
obtained proportion of explained variance is returned.}

\item{lambda}{eigenvalues of the positive semidefinite precision matrix.}
}
\value{
The difference in proportion of explained variance in absolute values
  or observed proportion of explained variance (if \code{ev_xx=NULL}).
}
\description{
Computes the difference in absolute value between the desired and observed
proportion of explained variance from the first Principal Component of a
Principal Component Analysis applied on the covariance matrix. The precision
matrix is obtained by adding u to the diagonal of a positive semidefinite
matrix. This function is used to find the value of the constant u
that generates a covariance matrix with desired proportion of explained
variance.
}
\keyword{internal}
