% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_block.R
\name{BlockStructure}
\alias{BlockStructure}
\title{Block structure}
\usage{
BlockStructure(pk)
}
\arguments{
\item{pk}{vector encoding the grouping structure.}
}
\value{
A symmetric matrix of size \code{length(pk))}.
}
\description{
Generates a symmetric matrix encoding the block structure from the numbers of
variables in each group. This function can be used to visualise block IDs.
}
\examples{
# Example with 2 groups
mat <- BlockStructure(pk = rep(10, 2))

# Example with 5 groups
mat <- BlockStructure(pk = rep(10, 5))
}
\seealso{
\code{\link{GraphicalModel}}

Other multi-block functions: 
\code{\link{BlockLambdaGrid}()},
\code{\link{BlockMatrix}()}
}
\concept{multi-block functions}
