% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_dependence.R
\name{sv_dependence}
\alias{sv_dependence}
\alias{sv_dependence.default}
\alias{sv_dependence.shapviz}
\title{SHAP Dependence Plot}
\usage{
sv_dependence(object, ...)

\method{sv_dependence}{default}(object, ...)

\method{sv_dependence}{shapviz}(
  object,
  v,
  color_var = NULL,
  color = "#3b528b",
  viridis_args = getOption("shapviz.viridis_args"),
  jitter_width = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class "shapviz".}

\item{...}{Arguments passed to \code{geom_jitter()}.}

\item{v}{Column name of feature to be plotted.}

\item{color_var}{Feature name to be used on the color scale to investigate interactions.
The default is \code{NULL} (no color feature). An experimental option is "auto",
which selects - by a simple heuristic - a variable with seemingly strongest interaction.
Check details for how to change the color scale.}

\item{color}{Color to be used if \code{color_var = NULL}.}

\item{viridis_args}{List of viridis color scale arguments, see
\code{?ggplot2::scale_color_viridis_c()}. The default points to the global
option \code{shapviz.viridis_args}, which corresponds to
\code{list(begin = 0.25, end = 0.85, option = "inferno")}.
These values are passed to \code{ggplot2::scale_color_viridis_*()}.
For example, to switch to a standard viridis scale, you can either change the default
with \code{options(shapviz.viridis_args = NULL)} or set \code{viridis_args = NULL}.
Only relevant if \code{color_var} is not \code{NULL}.}

\item{jitter_width}{The amount of horizontal jitter. The default (\code{NULL}) will
use a value of 0.2 in case \code{v} is a factor, logical, or character variable, and
no jitter otherwise.}
}
\value{
An object of class \code{ggplot} representing a dependence plot.
}
\description{
Creates a scatter plot of the SHAP values of a feature against its feature values.
A second variable, \code{color_var}, can be selected to be used on the color axis.
In this way, one can get a sense of possible interaction effects.
Set \code{color_var = "auto"} to use a simple heuristic to select the color
feature with the strongest apparent interaction.
With discrete \code{v}, horizontal jitter is added by default.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method.

\item \code{shapviz}: SHAP dependence plot for shp object.
}}

\examples{
dtrain <- xgboost::xgb.DMatrix(data.matrix(iris[, -1]), label = iris[, 1])
fit <- xgboost::xgb.train(data = dtrain, nrounds = 50)
x <- shapviz(fit, X_pred = dtrain, X = iris[, -1])
sv_dependence(x, "Petal.Length")
sv_dependence(x, "Petal.Length", color_var = "Species")
sv_dependence(x, "Species", color_var = "auto")
}
\seealso{
\code{\link{potential_interactions}}
}
