% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac.R
\name{vaeac_get_extra_para_default}
\alias{vaeac_get_extra_para_default}
\title{Function to specify the extra parameters in the \code{vaeac} model}
\usage{
vaeac_get_extra_para_default(
  vaeac.model_description = make.names(Sys.time()),
  vaeac.folder_to_save_model = tempdir(),
  vaeac.pretrained_vaeac_model = NULL,
  vaeac.cuda = FALSE,
  vaeac.epochs_initiation_phase = 2,
  vaeac.epochs_early_stopping = NULL,
  vaeac.save_every_nth_epoch = NULL,
  vaeac.val_ratio = 0.25,
  vaeac.val_iwae_n_samples = 25,
  vaeac.batch_size = 64,
  vaeac.batch_size_sampling = NULL,
  vaeac.running_avg_n_values = 5,
  vaeac.skip_conn_layer = TRUE,
  vaeac.skip_conn_masked_enc_dec = TRUE,
  vaeac.batch_normalization = FALSE,
  vaeac.paired_sampling = TRUE,
  vaeac.masking_ratio = 0.5,
  vaeac.mask_gen_coalitions = NULL,
  vaeac.mask_gen_coalitions_prob = NULL,
  vaeac.sigma_mu = 10000,
  vaeac.sigma_sigma = 1e-04,
  vaeac.sample_random = TRUE,
  vaeac.save_data = FALSE,
  vaeac.log_exp_cont_feat = FALSE,
  vaeac.which_vaeac_model = "best",
  vaeac.save_model = TRUE
)
}
\arguments{
\item{vaeac.model_description}{String (default is \code{make.names(Sys.time())}). String containing, e.g., the name of the
data distribution or additional parameter information. Used in the save name of the fitted model. If not provided,
then a name will be generated based on \code{\link[base:Sys.time]{base::Sys.time()}} to ensure a unique name. We use \code{\link[base:make.names]{base::make.names()}} to
ensure a valid file name for all operating systems.}

\item{vaeac.folder_to_save_model}{String (default is \code{\link[base:tempfile]{base::tempdir()}}). String specifying a path to a folder where
the function is to save the fitted vaeac model. Note that the path will be removed from the returned
\code{\link[=explain]{explain()}} object if \code{vaeac.save_model = FALSE}. Furthermore, the model cannot be moved from its
original folder if we are to use the \code{\link[=vaeac_train_model_continue]{vaeac_train_model_continue()}} function to continue training the model.}

\item{vaeac.pretrained_vaeac_model}{List or String (default is \code{NULL}). 1) Either a list of class
\code{vaeac}, i.e., the list stored in \code{explanation$internal$parameters$vaeac} where \code{explanation} is the returned list
from an earlier call to the \code{\link[=explain]{explain()}} function. 2) A string containing the path to where the \code{vaeac}
model is stored on disk, for example, \code{explanation$internal$parameters$vaeac$models$best}.}

\item{vaeac.cuda}{Logical (default is \code{FALSE}). If \code{TRUE}, then the \code{vaeac} model will be trained using cuda/GPU.
If \code{\link[torch:cuda_is_available]{torch::cuda_is_available()}} is \code{FALSE}, we fall back to using the CPU. Using a GPU
for smaller tabular dataset often do not improve the efficiency.
See \code{vignette("installation", package = "torch")} fo help to enable running on the GPU (only Linux and Windows).}

\item{vaeac.epochs_initiation_phase}{Positive integer (default is \code{2}). The number of epochs to run each of the
\code{vaeac.n_vaeacs_initialize} \code{vaeac} models before continuing to train only the best performing model.}

\item{vaeac.epochs_early_stopping}{Positive integer (default is \code{NULL}). The training stops if there has been no
improvement in the validation IWAE for \code{vaeac.epochs_early_stopping} epochs. If the user wants the training process
to be solely based on this training criterion, then \code{vaeac.epochs} in \code{\link[=explain]{explain()}} should be set to a large
number. If \code{NULL}, then \code{shapr} will internally set \code{vaeac.epochs_early_stopping = vaeac.epochs} such that early
stopping does not occur.}

\item{vaeac.save_every_nth_epoch}{Positive integer (default is \code{NULL}). If provided, then the vaeac model after
every \code{vaeac.save_every_nth_epoch}th epoch will be saved.}

\item{vaeac.val_ratio}{Numeric (default is \code{0.25}). Scalar between \code{0} and \code{1} indicating the ratio of
instances from the input data which will be used as validation data. That is, \code{vaeac.val_ratio = 0.25} means
that \verb{75\%} of the provided data is used as training data, while the remaining \verb{25\%} is used as validation data.}

\item{vaeac.val_iwae_n_samples}{Positive integer (default is \code{25}). The number of generated samples used
to compute the IWAE criterion when validating the vaeac model on the validation data.}

\item{vaeac.batch_size}{Positive integer (default is \code{64}). The number of samples to include in each batch
during the training of the vaeac model. Used in \code{\link[torch:dataloader]{torch::dataloader()}}.}

\item{vaeac.batch_size_sampling}{Positive integer (default is \code{NULL}) The number of samples to include in
each batch when generating the Monte Carlo samples. If \code{NULL}, then the function generates the Monte Carlo samples
for the provided coalitions and all explicands sent to \code{\link[=explain]{explain()}} at the time.
The number of coalitions are determined by the \code{n_batches} used by \code{\link[=explain]{explain()}}. We recommend to tweak
\code{extra_computation_args$max_batch_size} and \code{extra_computation_args$min_n_batches}
rather than \code{vaeac.batch_size_sampling}. Larger batch sizes are often much faster provided sufficient memory.}

\item{vaeac.running_avg_n_values}{Positive integer (default is \code{5}). The number of previous IWAE values to include
when we compute the running means of the IWAE criterion.}

\item{vaeac.skip_conn_layer}{Logical (default is \code{TRUE}). If \code{TRUE}, we apply identity skip connections in each
layer, see \code{\link[=skip_connection]{skip_connection()}}. That is, we add the input \eqn{X} to the outcome of each hidden layer,
so the output becomes \eqn{X + activation(WX + b)}.}

\item{vaeac.skip_conn_masked_enc_dec}{Logical (default is \code{TRUE}). If \code{TRUE}, we apply concatenate skip
connections between the layers in the masked encoder and decoder. The first layer of the masked encoder will be
linked to the last layer of the decoder. The second layer of the masked encoder will be
linked to the second to last layer of the decoder, and so on.}

\item{vaeac.batch_normalization}{Logical (default is \code{FALSE}). If \code{TRUE}, we apply batch normalization after the
activation function. Note that if \code{vaeac.skip_conn_layer = TRUE}, then the normalization is applied after the
inclusion of the skip connection. That is, we batch normalize the whole quantity \eqn{X + activation(WX + b)}.}

\item{vaeac.paired_sampling}{Logical (default is \code{TRUE}). If \code{TRUE}, we apply paired sampling to the training
batches. That is, the training observations in each batch will be duplicated, where the first instance will be masked
by \eqn{S} while the second instance will be masked by \eqn{\bar{S}}. This ensures that the training of the
\code{vaeac} model becomes more stable as the model has access to the full version of each training observation. However,
this will increase the training time due to more complex implementation and doubling the size of each batch. See
\code{\link[=paired_sampler]{paired_sampler()}} for more information.}

\item{vaeac.masking_ratio}{Numeric (default is \code{0.5}). Probability of masking a feature in the
\code{\link[=mcar_mask_generator]{mcar_mask_generator()}} (MCAR = Missing Completely At Random). The MCAR masking scheme ensures that \code{vaeac}
model can do arbitrary conditioning as all coalitions will be trained. \code{vaeac.masking_ratio} will be overruled if
\code{vaeac.mask_gen_coalitions} is specified.}

\item{vaeac.mask_gen_coalitions}{Matrix (default is \code{NULL}). Matrix containing the coalitions that the
\code{vaeac} model will be trained on, see \code{\link[=specified_masks_mask_generator]{specified_masks_mask_generator()}}. This parameter is used internally
in \code{shapr} when we only consider a subset of coalitions, i.e., when
\code{n_coalitions} \eqn{< 2^{n_{\text{features}}}}, and for group Shapley, i.e.,
when \code{group} is specified in \code{\link[=explain]{explain()}}.}

\item{vaeac.mask_gen_coalitions_prob}{Numeric array (default is \code{NULL}). Array of length equal to the height
of \code{vaeac.mask_gen_coalitions} containing the probabilities of sampling the corresponding coalitions in
\code{vaeac.mask_gen_coalitions}.}

\item{vaeac.sigma_mu}{Numeric (default is \code{1e4}). One of two hyperparameter values in the normal-gamma prior
used in the masked encoder, see Section 3.3.1 in
\href{https://www.jmlr.org/papers/volume23/21-1413/21-1413.pdf}{Olsen et al. (2022)}.}

\item{vaeac.sigma_sigma}{Numeric (default is \code{1e-4}). One of two hyperparameter values in the normal-gamma prior
used in the masked encoder, see Section 3.3.1 in
\href{https://www.jmlr.org/papers/volume23/21-1413/21-1413.pdf}{Olsen et al. (2022)}.}

\item{vaeac.sample_random}{Logical (default is \code{TRUE}). If \code{TRUE}, the function generates random Monte Carlo samples
from the inferred generative distributions. If \code{FALSE}, the function use the most likely values, i.e., the mean and
class with highest probability for continuous and categorical, respectively.}

\item{vaeac.save_data}{Logical (default is \code{FALSE}). If \code{TRUE}, then the data is stored together with
the model. Useful if one are to continue to train the model later using \code{\link[=vaeac_train_model_continue]{vaeac_train_model_continue()}}.}

\item{vaeac.log_exp_cont_feat}{Logical (default is \code{FALSE}). If we are to \eqn{\log} transform all
continuous features before sending the data to \code{\link[=vaeac]{vaeac()}}. The \code{vaeac} model creates unbounded Monte Carlo
sample values. Thus, if the continuous features are strictly positive (as for, e.g., the Burr distribution and
Abalone data set), it can be advantageous to \eqn{\log} transform the data to unbounded form before using \code{vaeac}.
If \code{TRUE}, then \code{\link[=vaeac_postprocess_data]{vaeac_postprocess_data()}} will take the \eqn{\exp} of the results to get back to strictly
positive values when using the \code{vaeac} model to impute missing values/generate the Monte Carlo samples.}

\item{vaeac.which_vaeac_model}{String (default is \code{best}). The name of the \code{vaeac} model (snapshots from different
epochs) to use when generating the Monte Carlo samples. The standard choices are: \code{"best"} (epoch with lowest IWAE),
\code{"best_running"} (epoch with lowest running IWAE, see \code{vaeac.running_avg_n_values}), and \code{last} (the last epoch).
Note that additional choices are available if \code{vaeac.save_every_nth_epoch} is provided. For example, if
\code{vaeac.save_every_nth_epoch = 5}, then \code{vaeac.which_vaeac_model} can also take the values \code{"epoch_5"}, \code{"epoch_10"},
\code{"epoch_15"}, and so on.}

\item{vaeac.save_model}{Boolean. If \code{TRUE} (default), the \code{vaeac} model will be saved either in a
\code{\link[base:tempfile]{base::tempdir()}} folder or in a user specified location in \code{vaeac.folder_to_save_model}. If \code{FALSE}, then
the paths to model and the model will will be deleted from the returned object from \code{\link[=explain]{explain()}}.}
}
\value{
Named list of the default values \code{vaeac} extra parameter arguments specified in this function call.
Note that both \code{vaeac.model_description} and \code{vaeac.folder_to_save_model} will change with time and R session.
}
\description{
In this function, we specify the default values for the extra parameters used in \code{\link[=explain]{explain()}}
for \code{approach = "vaeac"}.
}
\details{
The \code{vaeac} model consists of three neural network (a full encoder, a masked encoder, and a decoder) based
on the provided \code{vaeac.depth} and \code{vaeac.width}. The encoders map the full and masked input
representations to latent representations, respectively, where the dimension is given by \code{vaeac.latent_dim}.
The latent representations are sent to the decoder to go back to the real feature space and
provide a samplable probabilistic representation, from which the Monte Carlo samples are generated.
We use the \code{vaeac} method at the epoch with the lowest validation error (IWAE) by default, but
other possibilities are available by setting the \code{vaeac.which_vaeac_model} parameter. See
\href{https://www.jmlr.org/papers/volume23/21-1413/21-1413.pdf}{Olsen et al. (2022)} for more details.
}
\references{
\itemize{
\item \href{https://www.jmlr.org/papers/volume23/21-1413/21-1413.pdf}{
Olsen, L. H., Glad, I. K., Jullum, M., & Aas, K. (2022). Using Shapley values and variational autoencoders to
explain predictive models with dependent mixed features. Journal of machine learning research, 23(213), 1-51}
}
}
\author{
Lars Henry Berge Olsen
}
