% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.sgs}
\alias{coef.sgs}
\title{Extracts coefficients for one of the following object types: \code{"sgs"}, \code{"sgs_cv"}, \code{"gslope"}, \code{"gslope_cv"}.}
\usage{
\method{coef}{sgs}(object, ...)
}
\arguments{
\item{object}{Object of one of the following classes: \code{"sgs"}, \code{"sgs_cv"}, \code{"gslope"}, \code{"gslope_cv"}.}

\item{...}{further arguments passed to stats function.}
}
\value{
The fitted coefficients
}
\description{
Print the coefficients using model fitted with one of the following functions: \code{\link[=fit_sgs]{fit_sgs()}}, \code{\link[=fit_sgs_cv]{fit_sgs_cv()}}, \code{\link[=fit_gslope]{fit_gslope()}}, \code{\link[=fit_gslope_cv]{fit_gslope_cv()}}. The predictions are calculated for each \code{"lambda"} value in the path.
}
\examples{
# specify a grouping structure
groups = c(1,1,1,2,2,3,3,3,4,4)
# generate data
data =  gen_toy_data(p=10, n=5, groups = groups, seed_id=3,group_sparsity=1)
# run SGS 
model = fit_sgs(X = data$X, y = data$y, groups = groups, type="linear", lambda = 1, alpha=0.95, 
vFDR=0.1, gFDR=0.1, standardise = "l2", intercept = TRUE, verbose=FALSE)
# use predict function
model_coef = coef(model)
}
\seealso{
\code{\link[=fit_sgs]{fit_sgs()}}, \code{\link[=fit_sgs_cv]{fit_sgs_cv()}}, \code{\link[=fit_gslope]{fit_gslope()}}, \code{\link[=fit_gslope_cv]{fit_gslope_cv()}}

Other SGS-methods: 
\code{\link{as_sgs}()},
\code{\link{fit_sgs}()},
\code{\link{fit_sgs_cv}()},
\code{\link{plot.sgs}()},
\code{\link{predict.sgs}()},
\code{\link{print.sgs}()},
\code{\link{scaled_sgs}()}

Other gSLOPE-methods: 
\code{\link{fit_gslope}()},
\code{\link{fit_gslope_cv}()},
\code{\link{plot.sgs}()},
\code{\link{predict.sgs}()},
\code{\link{print.sgs}()}
}
\concept{SGS-methods}
\concept{gSLOPE-methods}
