% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glg.R
\name{glg}
\alias{glg}
\title{Fitting multiple linear Generalized Log-gamma Regression Models}
\usage{
glg(
  formula,
  data,
  shape = 0.2,
  Tolerance = 5e-05,
  Maxiter = 1000,
  format = "complete",
  envelope = FALSE
)
}
\arguments{
\item{formula}{a symbolic description of the systematic component of the model to be fitted. See details for further information.}

\item{data}{an optional data frame, list containing the variables in the model.}

\item{shape}{an optional value for the shape parameter of the error distribution of a generalized log-gamma distribution. Default value is 0.2.}

\item{Tolerance}{an optional positive value, which represents the convergence criterion. Default value is 1e-04.}

\item{Maxiter}{an optional positive integer giving the maximal number of iterations for the estimating process. Default value is 1e03.}

\item{format}{an optional string value that indicates if you want a simple or a complete report of the estimating process. Default value is 'complete'.}

\item{envelope}{an optional and internal logical value that indicates if the glg function will be employed for build an envelope plot. Default value is 'FALSE'.}
}
\value{
mu a vector of parameter estimates associated with the location parameter.

sigma estimate of the scale parameter associated with the model.

lambda estimate of the shape parameter associated with the model.

interval estimate of a 95\% confidence interval for each estimate parameters associated with the model.

Deviance the deviance associated with the model.
}
\description{
\code{glg} is used to fit a multiple linear regression model suitable for analysis of data sets in which the response variable is continuous, strictly positive, and asymmetric.
In this setup, the location parameter of the response variable is explicitly modeled by a linear function of the parameters.
}
\examples{
set.seed(21)
rows <- 120
x1 <- rbinom(rows, 1, 0.5)
x2 <- runif(rows, 0, 1)
X <- cbind(x1,x2)
t_beta  <- c(0.5, 2)
t_sigma <- 1

######################
#                    #
# Extreme value case #
#                    #
######################

t_lambda <- 1 # 1 -0.9
error <- rglg(rows, 0, 1, t_lambda)
y1 <- X \%*\%t_beta + t_sigma * error
data.example <- data.frame(y1,X)               #    uq
fit <- glg(y1 ~ x1 + x2 - 1,data=data.example) # 4.002952
logLik(fit) # -183.907
summary(fit)
deviance_residuals(fit)
#############################
#                           #
# Normal case: A limit case #
#                           #
#############################
# When the parameter lambda goes to zero the GLG tends to a standard normal distribution.
set.seed(8142031)
y1 <- X \%*\%t_beta + t_sigma * rnorm(rows)
data.example <- data.frame(y1, X)
fit0 <- glg(y1 ~ x1 + x2 - 1,data=data.example)
logLik(fit0)
fit0$AIC
fit0$mu

############################################
#                                          #
#  A comparison with a normal linear model #
#                                          #
############################################

fit2 <- lm(y1 ~ x1 + x2 - 1,data=data.example)
logLik(fit2)
AIC(fit2)
coefficients(fit2)
}
\references{
Carlos Alberto Cardozo Delgado, Semi-parametric generalized log-gamma regression models. Ph. D. thesis. Sao Paulo University.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
