% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb-graph.R
\name{st_nb_delaunay}
\alias{st_nb_delaunay}
\alias{st_nb_gabriel}
\alias{st_nb_relative}
\title{Graph based neighbors}
\usage{
st_nb_delaunay(geometry, .id = NULL)

st_nb_gabriel(geometry, .nnmult = 3)

st_nb_relative(geometry, .nnmult = 3)
}
\arguments{
\item{geometry}{an object of class sfc. If polygons are used, points are generated using \code{sf::st_point_on_surface()}.}

\item{.id}{default \code{NULL}. Passed as \code{spdep::tri2nb(x, row.names = .id)} to \code{spdep}.}

\item{.nnmult}{default 3. Used for memory scalling. See \code{\link[spdep:graphneigh]{spdep::gabrielneigh()}} for more.}
}
\value{
an object of class nb
}
\description{
Create graph based neighbors on a set of points.
}
\details{
\itemize{
\item \code{st_nb_delaunay()} uses \code{spdep::tri2nb()}
\item \code{st_nb_gabriel()} uses \code{spdep::gabrielneigh()} and \code{spdep::graph2nb()}
\item \code{st_nb_relative()} uses \code{spdep::relativeneigh()} and \code{spdep::graph2nb()}
}

\code{st_nb_delaunay()} implements Delaunay triangulation via \code{spdep} and thus via \code{deldir}. Delaunay triangulation creates a mesh of triangles that connects all points in a set. It ensures that no point is in in the circumcircle of an triangle in the triangulation. As a result, Delaunay triangulation maximizes the minimum angle in each triangle consequently avoiding skinny triangles.

The Gabriel graph is a subgraph of the Delaunay triangulation. Edges are created when the closed disc between two points p, and q, contain no other points besides themselves.

The relative neighborhood graph (RNG) is based on the Delaunay triangulation. It connects two points when there are no other closer points to each of them. The RNG is a subgraph of the Delaunay triangulation.

Note that Delaunay triangulation assumes a plane and thus uses Euclidean distances.

See \code{\link[spdep:graphneigh]{spdep::gabrielneigh()}} for further descriptions of the graph neighbor implementations.
}
\examples{
geometry <- sf::st_centroid(sf::st_geometry(guerry))
st_nb_delaunay(geometry)
st_nb_gabriel(geometry)
st_nb_relative(geometry)
}
