% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply.R
\name{st_nb_apply}
\alias{st_nb_apply}
\title{Apply a function to neighbors}
\usage{
st_nb_apply(x, nb, wt, .f, suffix = "dbl", ...)
}
\arguments{
\item{x}{A vector that will be used for neighbor xij values.}

\item{nb}{A neighbor list object as created by \code{st_neighbors()}.}

\item{wt}{A weights list as created by \code{st_weights()}.}

\item{.f}{A function definition. There are three default objects that can be used inside of the function definition:
\itemize{
\item \code{.xij}: neighbor values of \code{x} for the ith observation. This is simply the subset of x based on the corresponding \code{nb} list values for each element.
\item \code{.nb}: neighbor positions.
\item \code{.wt}: neighbor weights value.
}

If any of these three function arguments are omitted from \code{.f}, dots (\code{...}) must be supplied.}

\item{suffix}{The \code{map} variant to use. Options are "dbl", "int", "lgl", "chr", "list".}

\item{...}{arguments to pass to \code{.f}}
}
\value{
a vector or list of with same length as \code{x}.
}
\description{
Sometimes one may want to create custom lag variables or create some other neighborhood level metric that may not be defined yet. This \code{st_nb_apply()} enables you to apply a function to each observation's (xi) neighbors (xij).
}
\details{
The below example calculates the spatial lag using \code{\link[=st_nb_apply]{st_nb_apply()}} and \code{\link[=st_lag]{st_lag()}} to illustrate how we can apply functions to neighbors.

Currently questioning the use case. \code{\link[=find_xj]{find_xj()}} is now exported and may negate the need for this function.
}
\examples{
library(magrittr)
guerry \%>\%
  dplyr::transmute(
    nb = st_contiguity(geometry),
    wt = st_weights(nb),
    lag_apply = st_nb_apply(
      crime_pers, nb, wt,
      .f = function(.xij, .wt, ...) sum(.xij *.wt)
    ),
    lag = st_lag(crime_pers, nb, wt)
  )
}
