% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{geos}
\alias{geos}
\alias{st_dimension}
\alias{geos}
\alias{st_area}
\alias{geos}
\alias{st_length}
\alias{geos}
\alias{st_is_simple}
\alias{geos}
\alias{st_distance}
\alias{geos}
\alias{st_relate}
\alias{geos}
\alias{st_intersects}
\alias{geos}
\alias{st_disjoint}
\alias{geos}
\alias{st_touches}
\alias{geos}
\alias{st_crosses}
\alias{geos}
\alias{st_within}
\alias{geos}
\alias{st_contains}
\alias{geos}
\alias{st_contains_properly}
\alias{geos}
\alias{st_overlaps}
\alias{geos}
\alias{st_equals}
\alias{geos}
\alias{st_covers}
\alias{geos}
\alias{st_covered_by}
\alias{geos}
\alias{st_equals_exact}
\alias{geos}
\alias{st_buffer}
\alias{geos}
\alias{st_boundary}
\alias{geos}
\alias{st_convex_hull}
\alias{geos}
\alias{st_simplify}
\alias{geos}
\alias{st_triangulate}
\alias{geos}
\alias{st_voronoi}
\alias{geos}
\alias{st_polygonize}
\alias{geos}
\alias{st_line_merge}
\alias{geos}
\alias{st_centroid}
\alias{geos}
\alias{st_segmentize}
\alias{geos}
\alias{st_combine}
\alias{geos}
\alias{st_intersection}
\alias{geos}
\alias{st_difference}
\alias{geos}
\alias{st_sym_difference}
\alias{geos}
\alias{st_union}
\alias{geos}
\alias{st_line_sample}
\title{Geometric operations on (pairs of) simple feature geometry sets}
\usage{
st_dimension(x, NA_if_empty = TRUE)

st_area(x)

st_length(x, dist_fun = geosphere::distGeo)

st_is_simple(x)

st_distance(x, y, dist_fun)

st_relate(x, y, pattern = NA_character_, sparse = !is.na(pattern))

st_intersects(x, y, sparse = TRUE, prepared = TRUE)

st_disjoint(x, y, sparse = TRUE, prepared = TRUE)

st_touches(x, y, sparse = TRUE, prepared = TRUE)

st_crosses(x, y, sparse = TRUE, prepared = TRUE)

st_within(x, y, sparse = TRUE, prepared = TRUE)

st_contains(x, y, sparse = TRUE, prepared = TRUE)

st_contains_properly(x, y, sparse = TRUE, prepared = TRUE)

st_overlaps(x, y, sparse = TRUE, prepared = TRUE)

st_equals(x, y, sparse = TRUE, prepared = FALSE)

st_covers(x, y, sparse = TRUE, prepared = TRUE)

st_covered_by(x, y, sparse = TRUE, prepared = TRUE)

st_equals_exact(x, y, par, sparse = TRUE, prepared = FALSE)

st_buffer(x, dist, nQuadSegs = 30)

st_boundary(x)

st_convex_hull(x)

st_simplify(x, preserveTopology = FALSE, dTolerance = 0)

st_triangulate(x, dTolerance = 0, bOnlyEdges = FALSE)

st_voronoi(x, envelope, dTolerance = 0, bOnlyEdges = FALSE)

st_polygonize(x)

st_line_merge(x)

st_centroid(x)

st_segmentize(x, dfMaxLength, ...)

st_combine(x)

st_intersection(x, y)

st_difference(x, y)

st_sym_difference(x, y)

st_union(x, y, ..., by_feature = FALSE)

st_line_sample(x, n, density, type = "regular", sample = NULL)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{NA_if_empty}{logical; if TRUE, return NA for empty geometries}

\item{dist_fun}{function to be used for great circle distances of geographical coordinates; for unprojected (long/lat) data, this should be a distance function of package geosphere, or compatible to that; it defaults to \link[geosphere]{distGeo} in that case; for other data metric lengths are computed.}

\item{y}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{pattern}{character; define the pattern to match to, see details.}

\item{sparse}{logical; should a sparse matrix be returned (TRUE) or a dense matrix?}

\item{prepared}{logical; prepare geometry for x, before looping over y?}

\item{par}{numeric; parameter used for "equals_exact" (margin) and "is_within_distance"}

\item{dist}{numeric; buffer distance for all, or for each of the elements in \code{x}}

\item{nQuadSegs}{integer; number of segments per quadrant (fourth of a circle)}

\item{preserveTopology}{logical; carry out topology preserving simplification?}

\item{dTolerance}{numeric; tolerance parameter}

\item{bOnlyEdges}{logical; if TRUE, return lines, else return polygons}

\item{envelope}{object of class \code{sfc} or \code{sfg} with the envelope for a voronoi diagram}

\item{dfMaxLength}{maximum length of a line segment. If \code{x} has geographical coordinates (long/lat), \code{dfMaxLength} is a numeric with length with unit metre, or an object of class \code{units} with length units; in this case, segmentation takes place along the great circle, using \link[geosphere]{gcIntermediate}.}

\item{...}{ignored}

\item{by_feature}{logical; if TRUE, union each feature, if FALSE return a single feature with the union the set of features}

\item{n}{integer; number of points to choose per geometry; if missing, n will be computed as \code{round(density * st_length(geom))}.}

\item{density}{numeric; density (points per distance unit) of the sampling, possibly a vector of length equal to the number of features (otherwise recycled); \code{density} may be of class \code{units}.}

\item{type}{character; indicate the sampling type, either "regular" or "random"}

\item{sample}{numeric; a vector of numbers between 0 and 1 indicating the points to sample - if defined sample overrules n, density and type.}
}
\value{
vector, matrix, or if \code{sparse=TRUE} a list representing a sparse logical matrix; if dense: matrix of type \code{character} for \code{st_relate}, of type \code{numeric} for \code{st_distance}, and \code{logical} for all others; matrix has dimension \code{NROW(x)} by \code{NROW(y)}; if sparse (only for logical predicates): a list of length \code{NROW(x)}, with entry \code{i} an integer vector with the \code{TRUE} indices for that row (if \code{m} is the dense matrix, list entry \code{l[[i]]} is identical to \code{which(m[i,])}).

st_dimension returns a numeric vector with 0 for points, 1 for lines, 2 for surfaces, and, if \code{NA_if_empty} is \code{TRUE}, \code{NA} for empty geometries.

st_area returns the area of a geometry, in the coordinate reference system used; in case \code{x} is in degrees longitude/latitude, \link[geosphere]{areaPolygon} is used for area calculation.

st_length returns the length of a LINESTRING or MULTILINESTRING geometry, using the coordinate reference system used; if the coordinate reference system of \code{x} was set, the returned value has a unit of measurement. POINT or MULTIPOINT geometries return zero, POLYGON or MULTIPOLYGON are converted into LINESTRING or MULTILINESTRING, respectively.

st_is_simple returns a logical vector

st_distance returns a dense numeric matrix of dimension length(x) by length(y)

in case \code{pattern} is not given, st_relate returns a dense \code{character} matrix; element [i,j] has nine characters, refering to the DE9-IM relationship between x[i] and y[j], encoded as IxIy,IxBy,IxEy,BxIy,BxBy,BxEy,ExIy,ExBy,ExEy where I refers to interior, B to boundary, and E to exterior, and e.g. BxIy the dimensionality of the intersection of the the boundary of x[i] and the interior of y[j], which is one of {0,1,2,F}, digits denoting dimensionality, F denoting not intersecting. When \code{pattern} is given, returns a dense logical or sparse index list with matches to the given pattern; see also \url{https://en.wikipedia.org/wiki/DE-9IM}.

the binary logical functions (\code{st_intersects} up to \code{st_equals_exact}) return a sparse or dense logical matrix with rows and columns corresponding to the number of geometries (or rows) in x and y, respectively

\code{st_buffer}, \code{st_boundary}, \code{st_convex_hull}, \code{st_simplify},
\code{st_triangulate}, \code{st_voronoi}, \code{st_polygonize}, \code{st_line_merge},
\code{st_centroid} and \code{st_segmentize} return an \link{sfc} or an \link{sf} 
object with the same number of geometries as in \code{x}

All functions (or methods) returning a geometry return an object of the same class as that of the first argument (\code{x}).  \code{st_intersection}, \code{st_union}, \code{st_difference} and \code{st_sym_difference} return the non-empty geometries resulting from applying the operation to all geometry pairs in \code{x} and \code{y}, and return an object of class \code{sfg}, \code{sfc} or \code{sf}, where in the latter case the matching attributes of the original object(s) are added. The \code{sfc} geometry list-column returned carries an attribute \code{idx}, which is an \code{n x 2} matrix with every row the index of the corresponding entries of \code{x} and \code{y}, respectively. \code{st_union} has in addition the ability to work on a single argument \code{x} (\code{y} missing): in this case, if \code{by_feature} is \code{FALSE} all geometries are unioned together and an \code{sfg} or single-geometry \code{sfc} object is returned, if \code{by_feature} is \code{TRUE} each feature geometry is unioned; this can for instance be used to resolve internal boundaries after polygons were combined using \code{st_combine}.

\code{st_union(x)} unions geometries. Unioning a set of overlapping polygons has the effect of merging the areas (i.e. the same effect as iteratively unioning all individual polygons together). Unioning a set of LineStrings has the effect of fully noding and dissolving the input linework. In this context "fully noded" means that there will be a node or endpoint in the output for every endpoint or line segment crossing in the input. "Dissolved" means that any duplicate (e.g. coincident) line segments or portions of line segments will be reduced to a single line segment in the output.	Unioning a set of Points has the effect of merging al identical points (producing a set with no duplicates).
}
\description{
Geometric operations on (pairs of) simple feature geometry sets
}
\details{
function \code{dist_fun} should follow the pattern of the distance function \link[geosphere]{distGeo}: the first two arguments must be 2-column point matrices, the third the semi major axis (radius, in m), the third the ellipsoid flattening.

`st_contains_properly(A,B)` is true if A intersects B's interior, but not its edges or exterior; A contains A, but A does not properly contain A.

\code{st_triangulate} requires GEOS version 3.4 or above

\code{st_voronoi} requires GEOS version 3.4 or above

in case of \code{st_polygonize}, \code{x} must be an object of class \code{LINESTRING} or \code{MULTILINESTRING}, or an \code{sfc} geometry list-column object containing these

in case of \code{st_line_merge}, \code{x} must be an object of class \code{MULTILINESTRING}, or an \code{sfc} geometry list-column object containing these

\code{st_combine} combines geometries without resolving borders, using \link{c.sfg}; see \link{st_union} for resolving boundaries.
}
\examples{
x = st_sfc(
	st_point(0:1), 
	st_linestring(rbind(c(0,0),c(1,1))), 
	st_polygon(list(rbind(c(0,0),c(1,0),c(0,1),c(0,0)))),
	st_multipoint(),
	st_linestring(),
	st_geometrycollection())
st_dimension(x)
st_dimension(x, FALSE)
dist_vincenty = function(p1, p2, a, f) geosphere::distVincentyEllipsoid(p1, p2, a, a * (1-f), f)
line = st_sfc(st_linestring(rbind(c(30,30), c(40,40))), crs = 4326)
st_length(line)
st_length(line, dist_fun = dist_vincenty)
p1 = st_point(c(0,0))
p2 = st_point(c(2,2))
pol1 = st_polygon(list(rbind(c(0,0),c(1,0),c(1,1),c(0,1),c(0,0)))) - 0.5
pol2 = pol1 + 1
pol3 = pol1 + 2
st_relate(st_sfc(p1, p2), st_sfc(pol1, pol2, pol3))
sfc = st_sfc(st_point(c(0,0)), st_point(c(3,3)))
grd = st_make_grid(sfc, n = c(3,3))
st_intersects(grd)
st_relate(grd, pattern = "****1****") # sides, not corners, internals
st_relate(grd, pattern = "****0****") # only corners touch
st_rook = function(a, b = a) st_relate(a, b, pattern = "F***1****")
st_rook(grd)
# queen neighbours, see https://github.com/edzer/sfr/issues/234#issuecomment-300511129
st_queen <- function(a, b = a) st_relate(a, b, pattern = "F***T****")
nc = st_read(system.file("shape/nc.shp", package="sf"))
plot(st_convex_hull(nc))
plot(nc, border = grey(.5))
set.seed(1)
x = st_multipoint(matrix(runif(10),,2))
box = st_polygon(list(rbind(c(0,0),c(1,0),c(1,1),c(0,1),c(0,0))))
if (sf_extSoftVersion()["GEOS"] >= "3.5.0") {
 v = st_sfc(st_voronoi(x, st_sfc(box)))
 plot(v, col = 0, border = 1, axes = TRUE)
 plot(box, add = TRUE, col = 0, border = 1) # a larger box is returned, as documented
 plot(x, add = TRUE, col = 'red', cex=2, pch=16)
 plot(st_intersection(st_cast(v), box)) # clip to smaller box
 plot(x, add = TRUE, col = 'red', cex=2, pch=16)
}
mls = st_multilinestring(list(matrix(c(0,0,0,1,1,1,0,0),,2,byrow=TRUE)))
st_polygonize(st_sfc(mls))
mls = st_multilinestring(list(rbind(c(0,0), c(1,1)), rbind(c(2,0), c(1,1))))
st_line_merge(st_sfc(mls))
plot(nc, axes = TRUE)
plot(st_centroid(nc), add = TRUE, pch = 3)
sf = st_sf(a=1, geom=st_sfc(st_linestring(rbind(c(0,0),c(1,1)))), crs = 4326)
seg = st_segmentize(sf, units::set_units(100, km))
nrow(seg$geom[[1]])
st_combine(nc)
plot(st_union(nc))
ls = st_sfc(st_linestring(rbind(c(0,0),c(0,1))),
	st_linestring(rbind(c(0,0),c(10,0))))
st_line_sample(ls, density = 1)
ls = st_sfc(st_linestring(rbind(c(0,0),c(0,1))),
 st_linestring(rbind(c(0,0),c(.1,0))), crs = 4326)
try(st_line_sample(ls, density = 1/1000)) # error
st_line_sample(st_transform(ls, 3857), n = 5) # five points for each line
st_line_sample(st_transform(ls, 3857), n = c(1, 3)) # one and three points
st_line_sample(st_transform(ls, 3857), density = 1/1000) # one per km
st_line_sample(st_transform(ls, 3857), density = c(1/1000, 1/10000)) # one per km, one per 10 km
st_line_sample(st_transform(ls, 3857), density = units::set_units(1, 1/km)) # one per km
# five equidistant points including start and end:
st_line_sample(st_transform(ls, 3857), sample = c(0, 0.25, 0.5, 0.75, 1)) 
}
