% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{st_transform}
\alias{st_transform}
\alias{st_transform.sf}
\alias{st_transform.sfc}
\alias{st_transform.sfg}
\title{transform or convert coordinates of simple feature}
\usage{
st_transform(x, crs)

\method{st_transform}{sfc}(x, crs, ...)

\method{st_transform}{sf}(x, crs, ...)

\method{st_transform}{sfg}(x, crs, ...)
}
\arguments{
\item{x}{object of class sf, sfc or sfg}

\item{crs}{coordinate reference system: integer with the epsg code, or character with proj4string}

\item{...}{ignored}
}
\description{
transform or convert coordinates of simple feature
}
\details{
transforms coordinates of object to new projection

the st_transform method for sfg objects assumes that the crs of the object is available as an attribute of that name.
}
\examples{
p1 = st_point(c(7,52))
p2 = st_point(c(-30,20))
sfc = st_sfc(p1, p2, crs = "+init=epsg:4326")
st_transform(sfc, "+init=epsg:3857")
st_transform(st_sf(a=2:1, geom=sfc), "+init=epsg:3857")
st_transform(structure(p1, proj4string = "+init=epsg:4326"), "+init=epsg:3857")
}

