% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operation_setproduct.R
\name{setproduct}
\alias{setproduct}
\alias{*.Set}
\title{Cartesian Product of Sets}
\usage{
setproduct(..., simplify = FALSE, nest = FALSE)

\method{*}{Set}(x, y)
}
\arguments{
\item{...}{\link{Set}s}

\item{simplify}{logical, if \code{TRUE} returns the result in its simplest (unwrapped) form, usually a \code{Set}
otherwise a \code{ProductSet}.}

\item{nest}{logical, if \code{FALSE} (default) then will treat any \link{ProductSet}s passed to \code{...} as unwrapped
\link{Set}s. See details and examples.}

\item{x, y}{\link{Set}}
}
\value{
Either an object of class \code{ProductSet} or an unwrapped object inheriting from \code{Set}.
}
\description{
Returns the cartesian product of objects inheriting from class \code{Set}.
}
\details{
The cartesian product of multiple sets, the 'n-ary Cartesian product', is often
implemented in programming languages as being identical to the cartesian product of two sets applied recursively.
However, for sets \eqn{X, Y, Z},
\deqn{XYZ \ne (XY)Z}{X × Y × Z != (X × Y) × Z}
This is accommodated with the \code{nest} argument. If \code{nest == TRUE} then \eqn{X*Y*Z == (X × Y) × Z}, i.e. the cartesian
product for two sets is applied recursively. If \code{nest == FALSE} then \eqn{X*Y*Z == (X × Y × Z)} and
the n-ary cartesian product is computed. As it appears the latter (n-ary product) is more common, \code{nest = FALSE}
is the default. The N-ary cartesian product of \eqn{N} sets, \eqn{X1,...,XN}, is defined as
\deqn{X1 × ... × XN = \\{(x1,...,xN) : x1 \epsilon X1 \cap ... \cap xN \epsilon XN\\}}{X1 × ... × XN = {(x1,...,xN) : x1 \epsilon X1 and ... and xN \epsilon xN}}
where \eqn{(x1,...,xN)} is a tuple.

The product of fuzzy and crisp sets first coerces fuzzy sets to crisp sets by finding their support.
}
\examples{
# difference between nesting
Set$new(1, 2) * Set$new(2, 3) * Set$new(4, 5)
setproduct(Set$new(1, 2) * Set$new(2, 3), Set$new(4, 5), nest = FALSE) # same as above
setproduct(Set$new(1, 2) * Set$new(2, 3), Set$new(4, 5), nest = TRUE)
unnest_set = setproduct(Set$new(1, 2) * Set$new(2, 3), Set$new(4, 5), nest = FALSE)
nest_set = setproduct(Set$new(1, 2) * Set$new(2, 3), Set$new(4, 5), nest = TRUE)
# note the difference when using contains
unnest_set$contains(Tuple$new(1,3,5))
nest_set$contains(Tuple$new(Tuple$new(1, 3), 5))

# product of two sets
Set$new(-2:4) * Set$new(2:5)
setproduct(Set$new(1,4,"a"), Set$new("a", 6))
setproduct(Set$new(1,4,"a"), Set$new("a", 6), simplify = TRUE)

# product of two intervals
Interval$new(1, 10) * Interval$new(5, 15)
Interval$new(1, 2, type = "()") * Interval$new(2, 3, type = "(]")
Interval$new(1, 5, class = "integer") *
    Interval$new(2, 7, class = "integer")

# product of mixed set types
Set$new(1:10) * Interval$new(5, 15)
Set$new(5,7) * Tuple$new(6, 8, 7)
FuzzySet$new(1,0.1) * Set$new(2)

# product of FuzzySet
FuzzySet$new(1, 0.1, 2, 0.5) * Set$new(2:5)

# product of conditional sets
ConditionalSet$new(function(x, y) x >= y) *
    ConditionalSet$new(function(x, y) x == y)

# product of special sets
PosReals$new() * NegReals$new()

}
\seealso{
Other operators: 
\code{\link{powerset}()},
\code{\link{setcomplement}()},
\code{\link{setintersect}()},
\code{\link{setpower}()},
\code{\link{setsymdiff}()},
\code{\link{setunion}()}
}
\concept{operators}
