% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_clean_functions.R
\name{aggregateData}
\alias{aggregateData}
\title{Aggregate data frames}
\usage{
aggregateData(list, n)
}
\arguments{
\item{list}{A list of data frame objects.}

\item{n}{The number of consecutive rows to aggregate over.}
}
\value{
A list of aggregated data frames with an additional column,
  \code{length}, to check that the function worked.
}
\description{
Aggregate the data frames in a list to reduce noise in movement recordings
}
\details{
This function requires that the change in time and change in position column
names are "dT", "dx", and "dy", respectively.

Movement recording data generated by the servosphere software is quite noisy
due to extraneous movements by the insect or side-to-side motion. Aggregating
the data by aggregating rows reduces this noise. Aggregating also reduces the
size of the data files, making future computing tasks faster.

To aggregate the data properly, we recommend watching recordings of the
target organism moving on the servosphere and determine the length of time it
takes the insect to move at least 50 percent of its body length. Use the time
it takes the insect to move at least 50 percent of its body length as the
minimum aggregation time. Longer periods may be necessary depending on the
size and movement of the insect.

The resulting data frames will have an additional column named "length". The
values in length should be approximately equal to the sum of dT from the n
rows aggregated over, i.e. if each observation from the un-aggregated data is 10
ms and the user aggregates these observations to 1 second, the value of
length should be approximately 1. Note that in aggregating the data frame, the
stimulus column will also be aggregated The stimulus status value at the first
row to be aggregated will become the value of the stimulus for the aggregated
row.
}
\examples{
# Aggregates every 5 rows in each data frame. Must be used after
# cleanNames()
 servosphere <- list(data.frame(id = rep(1, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("a", 200),
                                date = rep("2032018", 200)),
                     data.frame(id = rep(2, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("b", 200),
                                date = rep("2032018", 200)))
 servosphere <- aggregateData(servosphere, n = 5)
}
