% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{sst_call_api_method}
\alias{sst_call_api_method}
\title{Make a request to Serpstat API endpoint}
\usage{
sst_call_api_method(api_token, api_method, api_params = NULL)
}
\arguments{
\item{api_token}{Serpstat API token from the
\href{https://serpstat.com/users/profile/}{profile page}.}

\item{api_method}{Internal name of API method.}

\item{api_params}{A list of API parameters used by api_method. More
information about parameters in the
\href{https://serpstat.com/api/}{official docs}.}
}
\value{
The list with a response data.
}
\description{
Make a request to Serpstat API endpoint
}
\examples{
\donttest{
api_params <- list(
    query = 'serpstat.com',
    page  = 1,
    size  = 5
    )
serpstatr:::sst_call_api_method(
    api_token  = 'api_token',
    api_method = 'SerpstatLimitsProcedure.getStats',
    api_params = api_params
    )
    }
}
