% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/simulateSerologyData.R
\name{simulateSerologyData}
\alias{simulateSerologyData}
\title{Simulate Cross-Sectional Serology Data}
\usage{
simulateSerologyData(n = 500)
}
\arguments{
\item{n}{Number of simulations, default 500.}
}
\value{
A dataframe of simulated antibody data, with named columns IgG, IgM and IgA.
}
\description{
Function to simulate cross-sectional serology data for three antibodies: IgG, IgM, IgA.
The underlying parametric models are log-Normal distributions with parameters:
\itemize{
\item{IgG: \code{mu} = 1.246, \code{sd} = 0.757}
\item{IgM: \code{mu} = -0.764, \code{sd} = 0.413}
\item{IgA: \code{mu} = -1.13, \code{sd} = 0.318}
}
}
\examples{
# simulate 500 observations of cross-sectional serology data
simulateSerologyData()

# simulate 10 observations of cross-sectional serology data
simulateSerologyData(n = 10)
}

