% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat_ests_scatterplot.R
\name{strat_ests_scatterplot}
\alias{strat_ests_scatterplot}
\title{Scatterplot method for \code{summary.seroincidence.by} objects}
\usage{
strat_ests_scatterplot(
  object,
  xvar = strata(object)[1],
  alpha = 0.7,
  shape = 1,
  dodge_width = 0.001,
  CIs = FALSE,
  color_var = "nlm.convergence.code",
  group_var = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{summary.seroincidence.by} object
(generated by applying the \code{summary()}
method to the output of \code{\link[=est_seroincidence_by]{est_seroincidence_by()}}).}

\item{xvar}{the name of a stratifying variable in \code{object}}

\item{alpha}{transparency for the points in the graph
(1 = no transparency, 0 = fully transparent)}

\item{shape}{shape argument for \code{geom_point()}}

\item{dodge_width}{width for jitter}

\item{CIs}{\link{logical}, if \code{TRUE}, add CI error bars}

\item{color_var}{\link{character} which variable in \code{object} to use
to determine point color}

\item{group_var}{\link{character} which variable in \code{object} to use
to connect points with lines (\code{NULL} for no lines)}

\item{...}{unused}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object
}
\description{
Scatterplot method for \code{summary.seroincidence.by} objects
}
\examples{
library(dplyr)
library(ggplot2)

xs_data <-
  sees_pop_data_pk_100

curve <-
  typhoid_curves_nostrat_100 |>
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG"))

noise <-
  example_noise_params_pk

est2 <- est_seroincidence_by(
  strata = c("catchment", "ageCat"),
  pop_data = xs_data,
  sr_params = curve,
  noise_params = noise,
  curve_strata_varnames = NULL,
  noise_strata_varnames = NULL,
  antigen_isos = c("HlyE_IgG", "HlyE_IgA"),
  num_cores = 2 # Allow for parallel processing to decrease run time
)

est2sum <- summary(est2)

strat_ests_scatterplot(est2sum,
                       xvar = "ageCat",
                       color_var = "catchment",
                       CIs = TRUE,
                       group_var = "catchment")
}
\keyword{internal}
