% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seriate_best.R
\name{seriate_best}
\alias{seriate_best}
\alias{seriate_rep}
\alias{seriate_improve}
\title{Best Seriation}
\usage{
seriate_best(
  x,
  methods = NULL,
  control = NULL,
  criterion = NULL,
  rep = 10L,
  parallel = TRUE,
  verbose = TRUE,
  ...
)

seriate_rep(
  x,
  method = NULL,
  control = NULL,
  criterion = NULL,
  rep = 10L,
  parallel = TRUE,
  verbose = TRUE,
  ...
)

seriate_improve(
  x,
  order,
  criterion = NULL,
  control = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{the data.}

\item{methods}{a vector of character string with the name of the seriation
methods to try.}

\item{control}{a list of control options passed on to \code{\link[=seriate]{seriate()}}.
For \code{seriate_best()} control needs to be a named list of control lists
with the names matching the seriation methods.}

\item{criterion}{a character string with the \link{criterion} to optimize.}

\item{rep}{number of times to repeat the randomized seriation algorithm.}

\item{parallel}{logical; perform replications in parallel.
Uses \verb{[foreach]} if a
DoPar backend (e.g., \code{doParallel}) is rgistered.}

\item{verbose}{logical; show progress and results for different methods}

\item{...}{further arguments are passed on to the \code{\link[=seriate]{seriate()}}.}

\item{method}{a character string with the name of the seriation method
(default: varies by data type).}

\item{order}{a \code{ser_permutation} object for \code{x} or the name of a seriation method to start with.}
}
\value{
Returns an object of class \link{ser_permutation}.
}
\description{
Often the best seriation method for a particular dataset is not know and
heuristics may produce unstable results.
\code{seriate_best()} and \code{seriate_rep()} automatically try different seriation methods or
rerun randomized methods several times to find the best and order
given a criterion measure. \code{seriate_improve()} uses a local improvement strategy
to imporve an existing solution.
}
\details{
\code{seriate_rep()} rerun different seriation methods to find the best solution given a criterion
measure. Non-stochastic methods are automatically only run once.

\code{seriate_best()} runs a set of methods and returns the best result given a
criterion. Stochastic methods are automatically randomly restarted several times.

\code{seriate_improve()} improves a seriation order using simulated annealing using
a specified criterion measure. It uses \code{\link[=seriate]{seriate()}} with method "\code{GSA}",
a reduced probability to accept bad moves, and a lower minimum temperature. Control
parameters for this method are accepted.

Some methods support for parallel execution is provided using the \code{\link{foreach}} package. To
use parallel execution, a suitable backend needs to be registered (eee
the Examples section for using the \code{doParallel} package).
}
\examples{
data(SupremeCourt)
d_supreme <- as.dist(SupremeCourt)

# find best seriation order (tries by by default several fast methods)
o <- seriate_best(d_supreme, criterion = "AR_events")
o
pimage(d_supreme, o)

# run a randomized algorithms several times. Repetition information
# is returned as attributes
o <- seriate_rep(d_supreme, "QAP_2SUM", rep = 5)

attr(o, "criterion")
hist(attr(o, "criterion_distribution"))
pimage(d_supreme, o)

\dontrun{
# Using parallel execution on a larger dataset
data(iris)
m_iris <- as.matrix(iris[sample(seq(nrow(iris))),-5])
d_iris <- dist(m_iris)

library(doParallel)
registerDoParallel(cores = detectCores() - 1L)

# seriate rows of the iris data set
o <- seriate_best(d_iris)
o

pimage(d_iris, o)

# improve the order to minimize RGAR
o_improved <- seriate_improve(d_iris, o, criterion = "RGAR")
pimage(d_iris, o_improved)

# available control parameters for seriate_improve()
get_seriation_method(name = "GSA")
}
}
\seealso{
Other seriation: 
\code{\link{register_DendSer}()},
\code{\link{register_GA}()},
\code{\link{register_optics}()},
\code{\link{register_smacof}()},
\code{\link{register_tsne}()},
\code{\link{register_umap}()},
\code{\link{registry_for_seriaiton_methods}},
\code{\link{seriate}()}
}
\author{
Michael Hahsler
}
\concept{seriation}
\keyword{cluster}
\keyword{optimize}
