% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqminer.R
\name{readPlinkToMatrixByIndex}
\alias{readPlinkToMatrixByIndex}
\title{Read a gene from BGEN file and return a genotype matrix}
\usage{
readPlinkToMatrixByIndex(plinkFileObject, sampleIndex, markerIndex)
}
\arguments{
\item{plinkFileObject}{a PlinkFileObject obtained by openPlink()}

\item{sampleIndex}{integer, 1-basd, index of samples to be extracted}

\item{markerIndex}{integer, 1-basd, index of markers to be extracted}
}
\value{
genotype matrix, marker by sample
}
\description{
Read a gene from BGEN file and return a genotype matrix
}
\examples{
## these indice are nonsynonymous markers for 1:196621007-196716634",
## refer to the readVCFToMatrixByRange()
fileName = system.file("plink/all.anno.filtered.extract.bed", package = "seqminer")
fileName = sub(fileName, pattern = ".bed", replacement = "")
sampleIndex = seq(3)
markerIndex =c(14, 36)
cfh <- readPlinkToMatrixByIndex(fileName, sampleIndex, markerIndex)
}
\seealso{
http://zhanxw.com/seqminer/ for online manual and examples
}
