% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqICP.s.R
\name{seqICP.s}
\alias{seqICP.s}
\title{Sequential Invariant Causal Prediction for an individual
  set S}
\usage{
seqICP.s(X, Y, S, test = "decoupled", par.test = list(grid = c(0,
  round(nrow(X)/2), nrow(X)), complements = FALSE, link = sum, alpha = 0.05, B =
  100, permutation = FALSE), model = "iid", par.model = list(pknown = FALSE,
  p = 0, max.p = 10))
}
\arguments{
\item{X}{matrix of predictor variables. Each column corresponds to
one predictor variable.}

\item{Y}{vector of target variable, with length(Y)=nrow(X).}

\item{S}{vector containing the indicies of predictors to be tested}

\item{test}{string specifying the hypothesis test used to test for
invariance of a parent set S (i.e. the null hypothesis
H0_S). The following tests are available: "decoupled",
"combined", "trend", "variance", "block.mean", "block.variance",
"block.decoupled", "smooth.mean", "smooth.variance",
"smooth.decoupled" and "hsic".}

\item{par.test}{parameters specifying hypothesis test. The
following parameters are available: \code{grid},
\code{complements}, \code{link}, \code{alpha}, \code{B} and
\code{permutation}. The parameter \code{grid} is an increasing
vector of gridpoints used to construct enviornments for change
point based tests. If the parameter \code{complements} is 'TRUE'
each environment is compared against its complement if it is
'FALSE' all environments are compared pairwise. The parameter
\code{link} specifies how to compare the pairwise test
statistics, generally this is either max or sum. The parameter
\code{alpha} is a numeric value in (0,1) indicting the
significance level of the hypothesis test. The parameter
\code{B} is an integer and specifies the number of Monte-Carlo
samples (or permutations) used in the approximation of the null
distribution. If the parameter \code{permutation} is 'TRUE' a
permuatation based approach is used to approximate the null
distribution, if it is 'FALSE' the scaled residuals approach is
used.}

\item{model}{string specifying the underlying model class. Either
"iid" if Y consists of independent observations or "ar" if Y has
a linear time dependence structure.}

\item{par.model}{parameters specifying model. The following
parameters are available: \code{pknown}, \code{p} and
\code{max.p}. If \code{pknown} is 'FALSE' the number of lags will be
determined by comparing all fits up to \code{max.p} lags using
the AIC criterion. If \code{pknown} is 'TRUE' the procedure will fit
\code{p} lags.}
}
\value{
list containing the following elements

\item{test.stat}{value of the test statistic.}

\item{crit.value}{critical value computed using a Monte-Carlo
simulation of the null distribution.}

\item{p.value}{p-value.}

\item{p}{number of lags that were used.}

\item{model.fit}{'lm' object of linear model fit.}
}
\description{
Tests whether the conditional distribution of Y given X^S is
invariant across time, by assuming a linear dependence model.
}
\details{
The function can be applied to two types of models\cr
(1) a linear model (model="iid")\cr Y_i = a X_i^S + N_i\cr with iid noise N_i and \cr
(2) a linear autoregressive model (model="ar")\cr Y_t = a_0 X_t^S + ... + a_p (Y_(t-p),X_(t-p)) + N_t\cr with iid noise N_t.

For both models the hypothesis test specified by the \code{test}
parameter is used to test whether the set S leads to an invariant
model. For futher details see the references.
}
\examples{
set.seed(1)

# environment 1
na <- 130
X1a <- rnorm(na,0,0.1)
Ya <- 5*X1a+rnorm(na,0,0.5)
X2a <- Ya+rnorm(na,0,0.1)

# environment 2
nb <- 70
X1b <- rnorm(nb,-1,1)
Yb <- 5*X1b+rnorm(nb,0,0.5)
X2b <- rnorm(nb,0,0.1)

# combine environments
X1 <- c(X1a,X1b)
X2 <- c(X2a,X2b)
Y <- c(Ya,Yb)
Xmatrix <- cbind(X1, X2)

# apply seqICP.s to all possible sets - only the true parent set S=1
# is invariant in this example
seqICP.s(Xmatrix, Y, S=numeric(), par.test=list(grid=c(0,50,100,150,200)))
seqICP.s(Xmatrix, Y, S=1, par.test=list(grid=c(0,50,100,150,200)))
seqICP.s(Xmatrix, Y, S=2, par.test=list(grid=c(0,50,100,150,200)))
seqICP.s(Xmatrix, Y, S=c(1,2), par.test=list(grid=c(0,50,100,150,200)))
}
\references{
Pfister, N., P. Bühlmann and J. Peters (2017).
Invariant Causal Prediction for Sequential Data. ArXiv e-prints (1706.08058).

Peters, J., P. Bühlmann, and N. Meinshausen (2016).
Causal inference using invariant prediction: identification and confidence intervals.
Journal of the Royal Statistical Society, Series B (with discussion) 78 (5), 947–1012.
}
\seealso{
To estimate the set of causal parents use the function
  \code{\link{seqICP}}. For non-linear models use the
  corresponding functions \code{\link{seqICPnl}} and
  \code{\link{seqICPnl.s}}.
}
\author{
Niklas Pfister and Jonas Peters
}
