% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather_se.R
\name{gather_se}
\alias{gather_se}
\title{Distribute columns into blocks of rows.}
\usage{
gather_se(
  data,
  ...,
  key = "key",
  value = "value",
  columns = NULL,
  na.rm = FALSE,
  convert = FALSE,
  factor_key = FALSE,
  use_one_of = TRUE
)
}
\arguments{
\item{data}{data.frame to take values from.}

\item{...}{not used, force later arguments to bind by name.}

\item{key}{character, name for new column to record which columns values were taken from.}

\item{value}{character, name for new column to record values.}

\item{columns}{character, names of columns to take values from.}

\item{na.rm}{passed to gather.}

\item{convert}{passed to gather.}

\item{factor_key}{passed to gather.}

\item{use_one_of}{logical, if TRUE use dplyr::one_of() instead of rlang:::`!!!`.}
}
\value{
converted data.
}
\description{
A standard (value-oriented) interface for \code{\link[tidyr]{gather}}.
Take values from the columns named in the \code{columns} argument and
move them into blocks of rows, placing values in the new column specified by \code{value}
and indicating which column each value came from in the new column specified by \code{key}.
}
\examples{

d <- wrapr::build_frame(
    'id', 'measurement1', 'measurement2' |
    1   , 'a'           , 10             |
    2   , 'b'           , 20             )
gather_se(d,
  key = "value_came_from_column",
  value = "value_was",
  columns = c("measurement1", "measurement2"))

}
\seealso{
\code{\link[tidyr]{gather}}, \code{\link{spread_se}}
}
